/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.settings.client.leaderboard;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettingsDialogComponent;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiRaceLeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.RaceColumnSelectionStrategies;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiRaceLeaderboardSettingsDialogComponent
extends LeaderboardSettingsDialogComponent<MultiRaceLeaderboardSettings> {
    private final Map<String, CheckBox> raceColumnCheckboxes;
    private final List<String> raceAllRaceColumnNames;
    private RaceColumnSelectionStrategies activeRaceColumnSelectionStrategy;

    public MultiRaceLeaderboardSettingsDialogComponent(MultiRaceLeaderboardSettings initialSettings, List<String> allRaceColumnNames, StringMessages stringMessages, Iterable<DetailType> availableDetailTypes, boolean canBoatInfoBeShown, PaywallResolver paywallResolver, AbstractLeaderboardDTO leaderboardDTO) {
        super((LeaderboardSettings)initialSettings, stringMessages, availableDetailTypes, canBoatInfoBeShown, paywallResolver, leaderboardDTO);
        this.activeRaceColumnSelectionStrategy = initialSettings.getActiveRaceColumnSelectionStrategy();
        this.raceAllRaceColumnNames = allRaceColumnNames;
        this.raceColumnCheckboxes = new LinkedHashMap();
    }

    public MultiRaceLeaderboardSettings getResult() {
        List maneuverDetailsToShow = this.getSelected(this.maneuverDetailCheckboxes, ((MultiRaceLeaderboardSettings)this.initialSettings).getManeuverDetailsToShow());
        List overallDetailsToShow = this.getSelected(this.overallDetailCheckboxes, ((MultiRaceLeaderboardSettings)this.initialSettings).getOverallDetailsToShow());
        List raceDetailsToShow = this.getSelected(this.raceDetailCheckboxes, ((MultiRaceLeaderboardSettings)this.initialSettings).getRaceDetailsToShow());
        List legDetailsToShow = this.getSelected(this.legDetailCheckboxes, ((MultiRaceLeaderboardSettings)this.initialSettings).getLegDetailsToShow());
        ArrayList<String> namesOfRaceColumnsToShow = null;
        if (this.activeRaceColumnSelectionStrategy == RaceColumnSelectionStrategies.EXPLICIT) {
            namesOfRaceColumnsToShow = new ArrayList<String>();
            for (Map.Entry entry : this.raceColumnCheckboxes.entrySet()) {
                if (!((CheckBox)entry.getValue()).getValue().booleanValue()) continue;
                namesOfRaceColumnsToShow.add((String)entry.getKey());
            }
        }
        Long delayBetweenAutoAdvancesValue = (Long)this.refreshIntervalInSecondsBox.getValue();
        Integer lastNRacesToShowValue = this.activeRaceColumnSelectionStrategy == RaceColumnSelectionStrategies.LAST_N ? (Integer)this.numberOfLastRacesToShowBox.getValue() : null;
        MultiRaceLeaderboardSettings newSettings = new MultiRaceLeaderboardSettings((Collection)maneuverDetailsToShow, (Collection)legDetailsToShow, (Collection)raceDetailsToShow, (Collection)overallDetailsToShow, namesOfRaceColumnsToShow, lastNRacesToShowValue, Long.valueOf(1000L * (delayBetweenAutoAdvancesValue == null ? 0L : delayBetweenAutoAdvancesValue)), this.activeRaceColumnSelectionStrategy, this.showAddedScoresCheckBox.getValue().booleanValue(), this.showCompetitorShortNameColumnCheckBox.getValue().booleanValue(), this.showCompetitorFullNameColumnCheckBox.getValue().booleanValue(), this.showCompetitorBoatInfoColumnCheckBox.getValue().booleanValue(), this.isCompetitorNationalityColumnVisible.getValue().booleanValue(), new SecurityChildSettingsContext((SecuredDTO)this.leaderboardDTO, this.paywallResolver));
        return newSettings;
    }

    private FlowPanel createSelectedRacesPanel(DataEntryDialog<?> dialog) {
        FlowPanel selectedRacesPanel = new FlowPanel();
        selectedRacesPanel.ensureDebugId("RaceSelectionSettingsPanel");
        selectedRacesPanel.addStyleName("SettingsDialogComponent");
        selectedRacesPanel.add((Widget)dialog.createHeadline(this.stringMessages.selectedRaces(), true));
        HorizontalPanel racesSelectionStrategyPanel = new HorizontalPanel();
        selectedRacesPanel.add((Widget)racesSelectionStrategyPanel);
        FlowPanel selectedRacesContent = new FlowPanel();
        selectedRacesContent.addStyleName("dialogInnerContent");
        selectedRacesPanel.add((Widget)selectedRacesContent);
        int racesCount = this.raceAllRaceColumnNames.size();
        if (racesCount > 0) {
            FlowPanel explicitRaceSelectionContent = new FlowPanel();
            explicitRaceSelectionContent.ensureDebugId("ExplicitRaceSelectionPanel");
            FlowPanel lastNRacesSelectionContent = new FlowPanel();
            lastNRacesSelectionContent.ensureDebugId("MostCurrentRacesSelectionPanel");
            String radioButtonGroupName = "raceSelectionStrategyGroup";
            Label raceSelectionWayLabel = new Label(String.valueOf(this.stringMessages.chooseTheWayYouSelectRaces()) + ":");
            raceSelectionWayLabel.getElement().getStyle().setPaddingRight(5.0, Style.Unit.PX);
            racesSelectionStrategyPanel.add((Widget)raceSelectionWayLabel);
            this.explicitRaceColumnSelectionRadioBtn = dialog.createRadioButton(radioButtonGroupName, this.stringMessages.selectFromAllRaces());
            this.explicitRaceColumnSelectionRadioBtn.ensureDebugId("ExplicitRaceSelectionRadioButton");
            racesSelectionStrategyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            this.explicitRaceColumnSelectionRadioBtn.setValue(Boolean.valueOf(this.activeRaceColumnSelectionStrategy == RaceColumnSelectionStrategies.EXPLICIT));
            this.explicitRaceColumnSelectionRadioBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            racesSelectionStrategyPanel.add((Widget)this.explicitRaceColumnSelectionRadioBtn);
            int maxRacesPerRow = 10;
            int rowIndex = 0;
            int columnIndex = 0;
            int rowCount = racesCount / maxRacesPerRow;
            if (racesCount % maxRacesPerRow != 0) {
                ++rowCount;
            }
            Grid grid = new Grid(rowCount, maxRacesPerRow);
            List namesOfRaceColumnsToShow = ((MultiRaceLeaderboardSettings)this.initialSettings).getNamesOfRaceColumnsToShow();
            boolean noRaceSelected = namesOfRaceColumnsToShow == null || Util.isEmpty((Iterable)namesOfRaceColumnsToShow);
            for (String raceColumnName : this.raceAllRaceColumnNames) {
                CheckBox checkbox = this.createCheckbox(dialog, raceColumnName, noRaceSelected || Util.contains((Iterable)namesOfRaceColumnsToShow, (Object)raceColumnName), null);
                this.raceColumnCheckboxes.put(raceColumnName, checkbox);
                grid.setWidget(rowIndex, columnIndex++, (Widget)checkbox);
                if (columnIndex != maxRacesPerRow) continue;
                ++rowIndex;
                columnIndex = 0;
            }
            explicitRaceSelectionContent.add((Widget)grid);
            explicitRaceSelectionContent.setVisible(this.activeRaceColumnSelectionStrategy == RaceColumnSelectionStrategies.EXPLICIT);
            selectedRacesContent.add((Widget)explicitRaceSelectionContent);
            this.lastNRacesColumnSelectionRadioBtn = dialog.createRadioButton(radioButtonGroupName, this.stringMessages.selectANumberOfRaces());
            this.lastNRacesColumnSelectionRadioBtn.ensureDebugId("MostCurrentRacesSelectionRadioButton");
            this.lastNRacesColumnSelectionRadioBtn.setValue(Boolean.valueOf(this.activeRaceColumnSelectionStrategy == RaceColumnSelectionStrategies.LAST_N));
            this.lastNRacesColumnSelectionRadioBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            racesSelectionStrategyPanel.add((Widget)this.lastNRacesColumnSelectionRadioBtn);
            dialog.alignAllPanelWidgetsVertically(racesSelectionStrategyPanel, HasVerticalAlignment.ALIGN_MIDDLE);
            HorizontalPanel hPanel = new HorizontalPanel();
            lastNRacesSelectionContent.add((Widget)hPanel);
            Label numberOfLastRacesLabel = new Label(String.valueOf(this.stringMessages.numberOfLastNRaces()) + ":");
            numberOfLastRacesLabel.getElement().getStyle().setPaddingRight(10.0, Style.Unit.PX);
            hPanel.add((Widget)numberOfLastRacesLabel);
            Integer numberOfLastRacesToShow = ((MultiRaceLeaderboardSettings)this.initialSettings).getNumberOfLastRacesToShow();
            this.numberOfLastRacesToShowBox = dialog.createIntegerBox(Integer.valueOf(numberOfLastRacesToShow != null ? numberOfLastRacesToShow : racesCount), 3);
            this.numberOfLastRacesToShowBox.ensureDebugId("NumberOfMostCurrentRacesIntegerBox");
            hPanel.add((Widget)this.numberOfLastRacesToShowBox);
            dialog.alignAllPanelWidgetsVertically(hPanel, HasVerticalAlignment.ALIGN_MIDDLE);
            lastNRacesSelectionContent.setVisible(this.activeRaceColumnSelectionStrategy == RaceColumnSelectionStrategies.LAST_N);
            selectedRacesContent.add((Widget)lastNRacesSelectionContent);
        } else {
            selectedRacesContent.add((Widget)new Label(this.stringMessages.noRacesYet()));
        }
        return selectedRacesPanel;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        FlowPanel dialogPanel = new FlowPanel();
        dialogPanel.ensureDebugId("LeaderboardSettingsPanel");
        dialogPanel.add((Widget)this.createSelectedRacesPanel(dialog));
        dialogPanel.add((Widget)this.createOverallDetailPanel(dialog));
        dialogPanel.add((Widget)this.createRaceDetailPanel(dialog));
        dialogPanel.add((Widget)this.createRaceStartAnalysisPanel(dialog));
        dialogPanel.add((Widget)this.createLegDetailsPanel(dialog));
        dialogPanel.add((Widget)this.createManeuverDetailsPanel(dialog));
        dialogPanel.add((Widget)this.createTimingDetailsPanel(dialog));
        return dialogPanel;
    }

    public DataEntryDialog.Validator<MultiRaceLeaderboardSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ void access$1(MultiRaceLeaderboardSettingsDialogComponent multiRaceLeaderboardSettingsDialogComponent, RaceColumnSelectionStrategies raceColumnSelectionStrategies) {
        multiRaceLeaderboardSettingsDialogComponent.activeRaceColumnSelectionStrategy = raceColumnSelectionStrategies;
    }
}

