/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.settings.client.leaderboard;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.RaceColumnSelectionStrategies;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.EnumSetting;
import com.sap.sse.common.settings.generic.IntegerSetting;
import com.sap.sse.common.settings.generic.StringSetSetting;
import com.sap.sse.common.settings.generic.support.SettingsUtil;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import java.util.Collection;
import java.util.List;

public class MultiRaceLeaderboardSettings
extends LeaderboardSettings {
    private static final long serialVersionUID = -3445146715292390755L;
    protected StringSetSetting namesOfRaceColumnsToShow;
    protected IntegerSetting numberOfLastRacesToShow;
    protected EnumSetting<RaceColumnSelectionStrategies> activeRaceColumnSelectionStrategy;

    public MultiRaceLeaderboardSettings(SecurityChildSettingsContext context) {
        super(false, context);
    }

    public MultiRaceLeaderboardSettings(Collection<DetailType> maneuverDetailsToShow, Collection<DetailType> legDetailsToShow, Collection<DetailType> raceDetailsToShow, Collection<DetailType> overallDetailsToShow, List<String> namesOfRaceColumnsToShow, Integer numberOfLastRacesToShow, Long delayBetweenAutoAdvancesInMilliseconds, RaceColumnSelectionStrategies activeRaceColumnSelectionStrategy, boolean showAddedScores, boolean showCompetitorShortNameColumn, boolean showCompetitorFullNameColumn, boolean showCompetitorBoatInfoColumn, boolean isCompetitorNationalityColumnVisible, SecurityChildSettingsContext context) {
        super(maneuverDetailsToShow, legDetailsToShow, raceDetailsToShow, overallDetailsToShow, delayBetweenAutoAdvancesInMilliseconds, showAddedScores, showCompetitorShortNameColumn, showCompetitorFullNameColumn, showCompetitorBoatInfoColumn, isCompetitorNationalityColumnVisible, context);
        this.namesOfRaceColumnsToShow.setValues(namesOfRaceColumnsToShow);
        this.numberOfLastRacesToShow.setValue((Object)numberOfLastRacesToShow);
        this.activeRaceColumnSelectionStrategy.setValue((Object)activeRaceColumnSelectionStrategy);
    }

    public MultiRaceLeaderboardSettings(Iterable<String> namesOfRaceColumnsToShow, SecurityChildSettingsContext context) {
        super(false, context);
        this.namesOfRaceColumnsToShow.setValues(namesOfRaceColumnsToShow);
    }

    protected void addChildSettings(SecurityChildSettingsContext context) {
        super.addChildSettings(context);
        this.namesOfRaceColumnsToShow = new StringSetSetting("namesOfRaceColumnsToShow", (AbstractGenericSerializableSettings)this);
        this.numberOfLastRacesToShow = new IntegerSetting("numberOfLastRacesToShow", (AbstractGenericSerializableSettings)this, null);
        this.activeRaceColumnSelectionStrategy = new EnumSetting("activeRaceColumnSelectionStrategy", (AbstractGenericSerializableSettings)this, (Enum)RaceColumnSelectionStrategies.EXPLICIT, RaceColumnSelectionStrategies::valueOf);
    }

    public List<String> getNamesOfRaceColumnsToShow() {
        return this.activeRaceColumnSelectionStrategy.getValue() == RaceColumnSelectionStrategies.EXPLICIT ? (this.namesOfRaceColumnsToShow.isValuesEmpty() ? null : Util.asList((Iterable)this.namesOfRaceColumnsToShow.getValues())) : null;
    }

    public Integer getNumberOfLastRacesToShow() {
        return this.activeRaceColumnSelectionStrategy.getValue() == RaceColumnSelectionStrategies.LAST_N ? (Integer)this.numberOfLastRacesToShow.getValue() : null;
    }

    public RaceColumnSelectionStrategies getActiveRaceColumnSelectionStrategy() {
        return (RaceColumnSelectionStrategies)this.activeRaceColumnSelectionStrategy.getValue();
    }

    public MultiRaceLeaderboardSettings withNamesOfRaceColumnsToShowDefaults(Iterable<String> namesOfRaceColumnsToShow, SecurityChildSettingsContext context) {
        MultiRaceLeaderboardSettings newSettings = new MultiRaceLeaderboardSettings(context);
        SettingsUtil.copyValuesAndDefaults((Settings)this, (Settings)this, (Settings)newSettings);
        newSettings.namesOfRaceColumnsToShow.setDefaultValues(namesOfRaceColumnsToShow);
        return newSettings;
    }

    public MultiRaceLeaderboardSettings withNamesOfRaceColumnsToShowDefaultsAndValues(Iterable<String> namesOfRaceColumnsToShow, SecurityChildSettingsContext context) {
        MultiRaceLeaderboardSettings newSettings = this.withNamesOfRaceColumnsToShowDefaults(namesOfRaceColumnsToShow, context);
        newSettings.namesOfRaceColumnsToShow.setValues(namesOfRaceColumnsToShow);
        return newSettings;
    }

    public MultiRaceLeaderboardSettings withRaceColumnSelectionValuesFrom(MultiRaceLeaderboardSettings settingsWithRaceColumnSelection) {
        MultiRaceLeaderboardSettings newSettings = new MultiRaceLeaderboardSettings((SecurityChildSettingsContext)settingsWithRaceColumnSelection.getContext());
        SettingsUtil.copyValuesAndDefaults((Settings)this, (Settings)this, (Settings)newSettings);
        newSettings.activeRaceColumnSelectionStrategy.setValue((Object)settingsWithRaceColumnSelection.getActiveRaceColumnSelectionStrategy());
        newSettings.numberOfLastRacesToShow.setValue((Object)settingsWithRaceColumnSelection.getNumberOfLastRacesToShow());
        newSettings.namesOfRaceColumnsToShow.setValues((Iterable)settingsWithRaceColumnSelection.getNamesOfRaceColumnsToShow());
        return newSettings;
    }

    public static MultiRaceLeaderboardSettings createDefaultSettingsWithLastNRaceColumnSelection(int numberOfLastRacesToShow, SecurityChildSettingsContext context) {
        MultiRaceLeaderboardSettings newSettings = new MultiRaceLeaderboardSettings(context);
        newSettings.namesOfRaceColumnsToShow.setValues(null);
        newSettings.activeRaceColumnSelectionStrategy.setValue((Object)RaceColumnSelectionStrategies.LAST_N);
        newSettings.numberOfLastRacesToShow.setValue((Object)numberOfLastRacesToShow);
        return newSettings;
    }
}

