/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.multiregattalist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressSeriesDTO;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaListResources;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaListSteps;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaListStepsBody;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import java.util.ArrayList;
import java.util.List;

public class MultiRegattaListSteps
extends Composite {
    private static MultiRegattaListStepsUiBinder uiBinder = (MultiRegattaListStepsUiBinder)GWT.create(MultiRegattaListStepsUiBinder.class);
    @UiField
    DivElement progressContainerUi;
    @UiField
    DivElement stepsContainerUi;
    @UiField
    DivElement noRacesMessageUi;
    @UiField
    DivElement leaderboardButtonContainerUi;
    @UiField
    AnchorElement leaderboardButtonUi;
    private HandlerRegistration windowResizeHandlerRegistration;
    private final List<MultiRegattaListStepsBody> allMultiregattaSteps = new ArrayList();

    public MultiRegattaListSteps(RegattaProgressDTO regattaProgress) {
        MultiRegattaListResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        double sumParts = 0.0;
        for (RegattaProgressSeriesDTO seriesProgress : regattaProgress.getSeries()) {
            double parts = Math.pow(seriesProgress.getMaxRacesPerFleet(), 0.4);
            sumParts += parts;
        }
        boolean showSeriesName = regattaProgress.getSeries().size() > 1;
        for (RegattaProgressSeriesDTO seriesProgress : regattaProgress.getSeries()) {
            double parts = Math.pow(seriesProgress.getMaxRacesPerFleet(), 0.4);
            double percentage = 100.0 * parts / sumParts;
            MultiRegattaListStepsBody stepsBody = new MultiRegattaListStepsBody(seriesProgress, showSeriesName);
            this.allMultiregattaSteps.add(stepsBody);
            stepsBody.getElement().getStyle().setWidth(percentage, Style.Unit.PCT);
            this.stepsContainerUi.appendChild((Node)stepsBody.getElement());
        }
        if (regattaProgress.getSeries().isEmpty()) {
            this.noRacesMessageUi.getStyle().clearDisplay();
            this.stepsContainerUi.removeFromParent();
        }
    }

    protected void onLoad() {
        for (MultiRegattaListStepsBody widget : this.allMultiregattaSteps) {
            widget.init();
        }
        this.windowResizeHandlerRegistration = Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onUnload() {
        this.windowResizeHandlerRegistration.removeHandler();
    }

    void setLeaderboardNavigation(HasRegattaMetadata.RegattaState regattaState, PlaceNavigation<?> placeNavigation) {
        placeNavigation.configureAnchorElement(this.leaderboardButtonUi);
        this.leaderboardButtonContainerUi.getStyle().clearDisplay();
        this.leaderboardButtonUi.addClassName(this.getLeaderboardButtonStyle(regattaState));
        this.stepsContainerUi.getStyle().setDisplay(Style.Display.NONE);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getLeaderboardButtonStyle(HasRegattaMetadata.RegattaState regattaState) {
        String liveStyle = SharedResources.INSTANCE.mainCss().buttonred();
        String defaultStyle = SharedResources.INSTANCE.mainCss().buttonprimary();
        return HasRegattaMetadata.RegattaState.RUNNING == regattaState ? liveStyle : defaultStyle;
    }

    static /* synthetic */ List access$0(MultiRegattaListSteps multiRegattaListSteps) {
        return multiRegattaListSteps.allMultiregattaSteps;
    }
}

