/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event.minileaderboard;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniLeaderboardDTO;
import com.sap.sailing.gwt.home.server.LeaderboardContext;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.util.UUID;

public class GetMiniOverallLeaderbordAction
implements SailingAction<ResultWithTTL<GetMiniLeaderboardDTO>>,
IsClientCacheable,
ProvidesLeaderboardRouting {
    private UUID leaderboardGroupUUID;
    private String leaderboardName;
    private int limit = 0;

    private GetMiniOverallLeaderbordAction() {
    }

    public GetMiniOverallLeaderbordAction(UUID leaderboardGroupUUID, String leaderboardName) {
        this(leaderboardGroupUUID, leaderboardName, 0);
    }

    public GetMiniOverallLeaderbordAction(UUID leaderboardGroupUUID, String leaderboardName, int limit) {
        this.leaderboardGroupUUID = leaderboardGroupUUID;
        this.leaderboardName = leaderboardName;
        this.limit = limit;
    }

    @GwtIncompatible
    public ResultWithTTL<GetMiniLeaderboardDTO> execute(SailingDispatchContext context) {
        LeaderboardGroup leaderboardGroup = context.getRacingEventService().getLeaderboardGroupByID(this.leaderboardGroupUUID);
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup);
        if (leaderboardGroup == null) {
            throw new RuntimeException("Invalid leaderboardGroupID");
        }
        Event event = HomeServiceUtil.determineBestMatchingEvent((RacingEventService)context.getRacingEventService(), (LeaderboardGroup)leaderboardGroup);
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        Leaderboard overallLeaderBoard = leaderboardGroup.getOverallLeaderboard();
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)overallLeaderBoard);
        LeaderboardContext lctx = new LeaderboardContext(context, event, event.getLeaderboardGroups(), overallLeaderBoard);
        return lctx.calculateMiniLeaderboard(context.getRacingEventService(), this.limit);
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.leaderboardGroupUUID).append("_").append(this.limit);
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }
}

