/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes.base;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.sap.sailing.gwt.autoplay.client.nodes.base.AutoPlayNode;
import com.sap.sailing.gwt.autoplay.client.nodes.base.BaseCompositeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AutoPlaySequenceNode
extends BaseCompositeNode {
    private List<AutoPlayNode> nodes = new ArrayList();
    private int sequenceTimePerNodeInSeconds;
    private int currentPos = -1;
    private Command onLoopEnd;
    private Timer transitionTimer = new /* Unavailable Anonymous Inner Class!! */;

    public AutoPlaySequenceNode(String name, int sequenceTimePerNodeInSeconds, AutoPlayNode ... nodes) {
        super(name);
        this.sequenceTimePerNodeInSeconds = sequenceTimePerNodeInSeconds;
        this.nodes.addAll(Arrays.asList(nodes));
    }

    private void gotoNext() {
        ++this.currentPos;
        if (this.currentPos > this.nodes.size() - 1) {
            if (this.onLoopEnd != null) {
                this.onLoopEnd.execute();
            }
        } else {
            this.transitionTo((AutoPlayNode)this.nodes.get(this.currentPos));
        }
    }

    protected void transitionTo(AutoPlayNode nextNode) {
        this.log("Sequence transition to " + nextNode);
        super.transitionTo(nextNode);
        if (!this.isStopped()) {
            this.transitionTimer.schedule(this.sequenceTimePerNodeInSeconds * 2000);
        }
    }

    public void setOnSequenceEnd(Command onLoopEnd) {
        this.onLoopEnd = onLoopEnd;
    }

    public void onStart() {
        this.currentPos = -1;
        this.gotoNext();
    }

    public void onStop() {
        super.onStop();
        for (AutoPlayNode autoPlayNode : this.nodes) {
            autoPlayNode.stop();
        }
        this.transitionTimer.cancel();
    }

    static /* synthetic */ void access$0(AutoPlaySequenceNode autoPlaySequenceNode) {
        autoPlaySequenceNode.gotoNext();
    }
}

