/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorChangeListener;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.CompetitorSerializationCustomizer;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class CompetitorImpl
implements DynamicCompetitor {
    private static final long serialVersionUID = 294603681016643157L;
    private final DynamicTeam team;
    private final Serializable id;
    private String name;
    private String shortName;
    private String searchTag;
    private Color color;
    private transient Set<CompetitorChangeListener> listeners;
    private String email;
    private URI flagImage;
    private Double timeOnTimeFactor;
    private Duration timeOnDistanceAllowancePerNauticalMile;

    public CompetitorImpl(Serializable id, String name, String shortName, Color color, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag) {
        this.assertFiniteTimeOnTimeFactor(timeOnTimeFactor);
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.team = team;
        this.color = color;
        this.email = email;
        this.flagImage = flagImage;
        this.timeOnTimeFactor = timeOnTimeFactor;
        this.timeOnDistanceAllowancePerNauticalMile = timeOnDistanceAllowancePerNauticalMile;
        this.searchTag = searchTag;
        this.listeners = new HashSet<CompetitorChangeListener>();
    }

    private Object writeReplace() {
        if (CompetitorSerializationCustomizer.getCurrentCustomizer().removalOfPersonalDataNecessary(this)) {
            return new CompetitorImpl(this.id, this.name, this.shortName, this.color, null, this.flagImage, this.team, this.timeOnTimeFactor, this.timeOnDistanceAllowancePerNauticalMile, this.searchTag);
        }
        return this;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.listeners = new HashSet<CompetitorChangeListener>();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getShortInfo() {
        String result = this.getShortName() != null ? this.getShortName() : null;
        return result;
    }

    @Override
    public boolean hasBoat() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String newName) {
        String oldName = this.name;
        if (!Util.equalsWithNull((Object)oldName, (Object)newName)) {
            this.name = newName;
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.nameChanged(oldName, newName);
            }
        }
    }

    @Override
    public void setShortName(String newShortName) {
        String oldShortName = this.shortName;
        if (!Util.equalsWithNull((Object)oldShortName, (Object)newShortName)) {
            this.shortName = newShortName;
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.shortNameChanged(oldShortName, newShortName);
            }
        }
    }

    public Serializable getId() {
        return this.id;
    }

    @Override
    public DynamicTeam getTeam() {
        return this.team;
    }

    @Override
    public Nationality getNationality() {
        return this.getTeam() == null ? null : this.getTeam().getNationality();
    }

    public Competitor resolve(SharedDomainFactory<?> domainFactory) {
        DynamicCompetitor result = domainFactory.getOrCreateCompetitor(this.getId(), this.getName(), this.getShortName(), this.getColor(), this.getEmail(), this.getFlagImage(), this.getTeam(), this.getTimeOnTimeFactor(), this.getTimeOnDistanceAllowancePerNauticalMile(), this.searchTag, true);
        return result;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        Color oldColor = this.color;
        if (!Util.equalsWithNull((Object)oldColor, (Object)color)) {
            this.color = color;
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.colorChanged(oldColor, color);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompetitorChangeListener(CompetitorChangeListener listener) {
        Set<CompetitorChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        this.getTeam().addNationalityChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCompetitorChangeListener(CompetitorChangeListener listener) {
        Set<CompetitorChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
        this.getTeam().removeNationalityChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<CompetitorChangeListener> getListeners() {
        Set<CompetitorChangeListener> set = this.listeners;
        synchronized (set) {
            return new HashSet<CompetitorChangeListener>(this.listeners);
        }
    }

    @Override
    public String getSearchTag() {
        return this.searchTag;
    }

    @Override
    public void setSearchTag(String newSearchTag) {
        String oldSearchTag = this.searchTag;
        if (!Util.equalsWithNull((Object)oldSearchTag, (Object)newSearchTag)) {
            this.searchTag = newSearchTag;
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.searchTagChanged(oldSearchTag, newSearchTag);
            }
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String newEmail) {
        String oldEmail = this.email;
        if (!Util.equalsWithNull((Object)oldEmail, (Object)newEmail)) {
            this.email = newEmail;
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.emailChanged(oldEmail, newEmail);
            }
        }
    }

    @Override
    public boolean hasEmail() {
        return this.email != null && !this.email.isEmpty();
    }

    @Override
    public URI getFlagImage() {
        return this.flagImage;
    }

    @Override
    public void setFlagImage(URI flagImage) {
        URI oldFlagImage = this.flagImage;
        this.flagImage = flagImage;
        if (!Util.equalsWithNull((Object)oldFlagImage, (Object)flagImage)) {
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.flagImageChanged(oldFlagImage, flagImage);
            }
        }
    }

    @Override
    public Double getTimeOnTimeFactor() {
        return this.timeOnTimeFactor;
    }

    @Override
    public Duration getTimeOnDistanceAllowancePerNauticalMile() {
        return this.timeOnDistanceAllowancePerNauticalMile;
    }

    @Override
    public void setTimeOnTimeFactor(Double timeOnTimeFactor) {
        this.assertFiniteTimeOnTimeFactor(timeOnTimeFactor);
        Double oldTimeOnTimeFactor = this.timeOnTimeFactor;
        this.timeOnTimeFactor = timeOnTimeFactor;
        if (!Util.equalsWithNull((Object)oldTimeOnTimeFactor, (Object)timeOnTimeFactor)) {
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.timeOnTimeFactorChanged(oldTimeOnTimeFactor, timeOnTimeFactor);
            }
        }
    }

    private void assertFiniteTimeOnTimeFactor(Double timeOnTimeFactor) {
        if (timeOnTimeFactor != null && !Double.isFinite(timeOnTimeFactor)) {
            throw new IllegalArgumentException("A competitor's time-on-time factor must be a finite number. " + timeOnTimeFactor + " is not.");
        }
    }

    @Override
    public void setTimeOnDistanceAllowancePerNauticalMile(Duration timeOnDistanceAllowancePerNauticalMile) {
        Duration oldTimeOnDistanceAllowancePerNauticalMile = this.timeOnDistanceAllowancePerNauticalMile;
        this.timeOnDistanceAllowancePerNauticalMile = timeOnDistanceAllowancePerNauticalMile;
        if (!Util.equalsWithNull((Object)oldTimeOnDistanceAllowancePerNauticalMile, (Object)timeOnDistanceAllowancePerNauticalMile)) {
            for (CompetitorChangeListener listener : this.getListeners()) {
                listener.timeOnDistanceAllowancePerNauticalMileChanged(oldTimeOnDistanceAllowancePerNauticalMile, timeOnDistanceAllowancePerNauticalMile);
            }
        }
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.COMPETITOR;
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return CompetitorImpl.getTypeRelativeObjectIdentifier(this.getId());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(Serializable id) {
        return new TypeRelativeObjectIdentifier(new String[]{id.toString()});
    }
}

