/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultsImpl;
import com.sap.sse.common.TimePoint;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AbstractFinishPositioningListFinder
extends RaceLogAnalyzer<CompetitorResultsAndTheirCreationTimePoints> {
    private final Class<? extends RaceLogFinishPositioningEvent> clz;

    public AbstractFinishPositioningListFinder(RaceLog raceLog, Class<? extends RaceLogFinishPositioningEvent> clz) {
        super(raceLog);
        this.clz = clz;
    }

    @Override
    protected CompetitorResultsAndTheirCreationTimePoints performAnalysis() {
        boolean resultFound = false;
        HashMap<Serializable, CompetitorResult> resultsByCompetitor = new HashMap<Serializable, CompetitorResult>();
        HashMap<Serializable, TimePoint> resultCreationTimePointsByCompetitorId = new HashMap<Serializable, TimePoint>();
        for (RaceLogEvent event : this.getPassEventsDescending()) {
            if (!this.clz.isInstance(event)) continue;
            RaceLogFinishPositioningEvent finishPositioningEvent = (RaceLogFinishPositioningEvent)event;
            CompetitorResults positionedCompetitorsIDsNamesMaxPointsReasons = finishPositioningEvent.getPositionedCompetitorsIDsNamesMaxPointsReasons();
            TimePoint creationTimePoint = finishPositioningEvent.getCreatedAt();
            if (positionedCompetitorsIDsNamesMaxPointsReasons == null) continue;
            resultFound = true;
            for (CompetitorResult r : positionedCompetitorsIDsNamesMaxPointsReasons) {
                if (resultsByCompetitor.containsKey(r.getCompetitorId())) continue;
                resultsByCompetitor.put(r.getCompetitorId(), r);
                resultCreationTimePointsByCompetitorId.put(r.getCompetitorId(), creationTimePoint);
            }
        }
        CompetitorResultsImpl result = new CompetitorResultsImpl();
        result.addAll(resultsByCompetitor.values());
        return new CompetitorResultsAndTheirCreationTimePoints(resultFound ? result : null, resultCreationTimePointsByCompetitorId);
    }

    public static class CompetitorResultsAndTheirCreationTimePoints {
        private final CompetitorResults competitorResults;
        private final Map<Serializable, TimePoint> resultCreationTimePointByCompetitorId;

        public CompetitorResultsAndTheirCreationTimePoints(CompetitorResults competitorResults, Map<Serializable, TimePoint> resultCreationTimePointByCompetitorId) {
            this.competitorResults = competitorResults;
            this.resultCreationTimePointByCompetitorId = resultCreationTimePointByCompetitorId;
        }

        public CompetitorResults getCompetitorResults() {
            return this.competitorResults;
        }

        public TimePoint getCreationTimePointOfResultForCompetitorWithId(Serializable competitorId) {
            return this.resultCreationTimePointByCompetitorId.get(competitorId);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.competitorResults == null ? 0 : this.competitorResults.hashCode());
            result = 31 * result + (this.resultCreationTimePointByCompetitorId == null ? 0 : this.resultCreationTimePointByCompetitorId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompetitorResultsAndTheirCreationTimePoints other = (CompetitorResultsAndTheirCreationTimePoints)obj;
            if (this.competitorResults == null ? other.competitorResults != null : !this.competitorResults.equals(other.competitorResults)) {
                return false;
            }
            return !(this.resultCreationTimePointByCompetitorId == null ? other.resultCreationTimePointByCompetitorId != null : !this.resultCreationTimePointByCompetitorId.equals(other.resultCreationTimePointByCompetitorId));
        }
    }
}

