/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.dto.DataMiningReportDTO;
import com.sap.sse.datamining.shared.dto.FilterDimensionParameter;
import com.sap.sse.datamining.shared.impl.dto.parameters.ValueListFilterParameter;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.gwt.client.controls.GenericListBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PickOrCreateReportParameterDialog
extends DataEntryDialog<FilterDimensionParameter> {
    private final StringMessages stringMessages;
    private final String typeName;
    private final GenericListBox<FilterDimensionParameter> parametersListBox;
    private final Set<FilterDimensionParameter> parametersAdded;
    private final Set<FilterDimensionParameter> parametersRemoved;

    public PickOrCreateReportParameterDialog(DataMiningReportDTO report, String typeName, StringMessages stringMessages, DataEntryDialog.DialogCallback<FilterDimensionParameter> callback) {
        this(report, typeName, stringMessages, callback, new HashSet<FilterDimensionParameter>(), new HashSet<FilterDimensionParameter>());
    }

    private PickOrCreateReportParameterDialog(DataMiningReportDTO report, String typeName, StringMessages stringMessages, DataEntryDialog.DialogCallback<FilterDimensionParameter> callback, Set<FilterDimensionParameter> parametersAdded, Set<FilterDimensionParameter> parametersRemoved) {
        super(stringMessages.pickOrCreateReportParameter(), stringMessages.pickOrCreateReportParameterMessage(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new ReportParameterValidator(stringMessages, report), (DataEntryDialog.DialogCallback)new Callback(report, callback, parametersAdded, parametersRemoved));
        this.stringMessages = stringMessages;
        this.typeName = typeName;
        this.parametersAdded = parametersAdded;
        this.parametersRemoved = parametersRemoved;
        this.parametersListBox = this.createGenericListBox(param -> param.getName(), false);
        for (FilterDimensionParameter existingParameters : report.getParametersForTypeName(typeName)) {
            this.parametersListBox.addItem((Object)existingParameters);
        }
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel mainPanel = new VerticalPanel();
        Label parameterTypeSelectionBoxLabel = new Label(this.stringMessages.parameterType(this.typeName));
        mainPanel.add((Widget)parameterTypeSelectionBoxLabel);
        HorizontalPanel listBoxAndButtons = new HorizontalPanel();
        mainPanel.add((Widget)listBoxAndButtons);
        listBoxAndButtons.add(this.parametersListBox);
        Button addButton = new Button(this.stringMessages.add());
        listBoxAndButtons.add((Widget)addButton);
        Button removeButton = new Button(this.stringMessages.remove());
        listBoxAndButtons.add((Widget)removeButton);
        addButton.addClickHandler(this::addParameterClicked);
        removeButton.addClickHandler(this::removeParameterClicked);
        return mainPanel;
    }

    protected Focusable getInitialFocusWidget() {
        return this.parametersListBox;
    }

    public void show() {
        super.show();
        if (this.parametersListBox.getItemCount() == 0) {
            this.addParameterClicked(null);
        }
    }

    protected FilterDimensionParameter getResult() {
        return (FilterDimensionParameter)this.parametersListBox.getValue();
    }

    private void addParameterClicked(ClickEvent e) {
        new AddParameterDialog((DataEntryDialog.DialogCallback)new DataEntryDialog.DialogCallback<String>(){

            public void ok(String newParameterName) {
                ValueListFilterParameter newParameter = new ValueListFilterParameter(newParameterName, PickOrCreateReportParameterDialog.this.typeName, Collections.emptySet());
                PickOrCreateReportParameterDialog.this.parametersAdded.add(newParameter);
                PickOrCreateReportParameterDialog.this.parametersListBox.addItem((Object)newParameter);
                PickOrCreateReportParameterDialog.this.parametersListBox.setSelectedIndex(PickOrCreateReportParameterDialog.this.parametersListBox.getItemCount() - 1);
                PickOrCreateReportParameterDialog.this.validateAndUpdate();
                PickOrCreateReportParameterDialog.this.getOkButton().setFocus(true);
            }

            public void cancel() {
            }
        }).show();
    }

    private void removeParameterClicked(ClickEvent e) {
        this.parametersRemoved.add((FilterDimensionParameter)this.parametersListBox.getValue());
        this.parametersListBox.removeItem(this.parametersListBox.getSelectedIndex());
    }

    private class AddParameterDialog
    extends DataEntryDialog<String> {
        private final TextBox nameField;

        private AddParameterDialog(DataEntryDialog.DialogCallback<String> callback) {
            super(PickOrCreateReportParameterDialog.this.stringMessages.newParameterName(), null, PickOrCreateReportParameterDialog.this.stringMessages.ok(), PickOrCreateReportParameterDialog.this.stringMessages.cancel(), (DataEntryDialog.Validator)new DataEntryDialog.Validator<String>(){

                public String getErrorMessage(String valueToValidate) {
                    String errorMessage = !Util.hasLength((String)valueToValidate) ? PickOrCreateReportParameterDialog.this.stringMessages.parameterNameMustNotBeEmpty() : (PickOrCreateReportParameterDialog.this.parametersListBox.getValues().stream().anyMatch(p -> Util.equalsWithNull((Object)valueToValidate, (Object)p.getName())) ? PickOrCreateReportParameterDialog.this.stringMessages.parameterNamesMustBeUniqueInReport(valueToValidate, PickOrCreateReportParameterDialog.this.typeName) : null);
                    return errorMessage;
                }
            }, callback);
            this.nameField = this.createTextBox("", 20);
        }

        protected Focusable getInitialFocusWidget() {
            return this.nameField;
        }

        protected Widget getAdditionalWidget() {
            return this.nameField;
        }

        protected String getResult() {
            return this.nameField.getValue();
        }
    }

    private static class Callback
    implements DataEntryDialog.DialogCallback<FilterDimensionParameter> {
        private final DataMiningReportDTO report;
        private final DataEntryDialog.DialogCallback<FilterDimensionParameter> callback;
        private Set<FilterDimensionParameter> parametersAdded;
        private Set<FilterDimensionParameter> parametersRemoved;

        public Callback(DataMiningReportDTO report, DataEntryDialog.DialogCallback<FilterDimensionParameter> callback, Set<FilterDimensionParameter> parametersAdded, Set<FilterDimensionParameter> parametersRemoved) {
            this.report = report;
            this.callback = callback;
            this.parametersAdded = parametersAdded;
            this.parametersRemoved = parametersRemoved;
        }

        public void ok(FilterDimensionParameter editedObject) {
            FilterDimensionParameter result = editedObject;
            for (FilterDimensionParameter parameterAdded : this.parametersAdded) {
                FilterDimensionParameter newParameter = this.report.createParameter(parameterAdded.getName(), parameterAdded.getTypeName(), Collections.emptySet());
                if (!Util.equalsWithNull((Object)editedObject.getName(), (Object)parameterAdded.getName())) continue;
                result = newParameter;
            }
            for (FilterDimensionParameter parameterRemoved : this.parametersRemoved) {
                this.report.removeParameter(parameterRemoved);
            }
            this.callback.ok((Object)result);
        }

        public void cancel() {
            this.callback.cancel();
        }
    }

    private static class ReportParameterValidator
    implements DataEntryDialog.Validator<FilterDimensionParameter> {
        private final StringMessages stringMessages;
        private final DataMiningReportDTO report;

        public ReportParameterValidator(StringMessages stringMessages, DataMiningReportDTO report) {
            this.stringMessages = stringMessages;
            this.report = report;
        }

        public String getErrorMessage(FilterDimensionParameter valueToValidate) {
            String result = null;
            if (valueToValidate == null) {
                result = this.stringMessages.pleaseSelect();
            } else {
                for (FilterDimensionParameter existingParameter : this.report.getParameters()) {
                    if (existingParameter == valueToValidate || !Util.equalsWithNull((Object)existingParameter.getName(), (Object)valueToValidate.getName())) continue;
                    result = this.stringMessages.parameterNamesMustBeUniqueInReport(valueToValidate.getName(), valueToValidate.getTypeName());
                }
            }
            return result;
        }
    }
}

