/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sse.landscape.aws.persistence.MongoObjectFactory;
import com.sap.sse.landscape.aws.persistence.impl.CollectionNames;
import com.sap.sse.landscape.aws.persistence.impl.FieldNames;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private final MongoDatabase db;

    public MongoObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
    }

    @Override
    public void clear() {
        this.db.getCollection(CollectionNames.SSH_KEY_PAIRS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED).drop();
    }

    @Override
    public void storeSSHKeyPair(SSHKeyPair keyPair) {
        Document query = this.getSSHKeyPairDBQuery(keyPair.getRegionId(), keyPair.getName());
        Document keyPairDocument = this.getSSHKeyPairDBQuery(keyPair.getRegionId(), keyPair.getName());
        keyPairDocument.put(FieldNames.SSH_KEY_PAIR_CREATOR_NAME.name(), (Object)keyPair.getCreatorName());
        keyPairDocument.put(FieldNames.SSH_KEY_PAIR_CREATION_DATE.name(), (Object)keyPair.getCreationTime().asMillis());
        keyPairDocument.put(FieldNames.SSH_KEY_PAIR_PUBLIC_KEY.name(), (Object)keyPair.getPublicKey());
        keyPairDocument.put(FieldNames.SSH_KEY_PAIR_ENCRYPTED_PRIVATE_KEY.name(), (Object)keyPair.getEncryptedPrivateKey());
        this.db.getCollection(CollectionNames.SSH_KEY_PAIRS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)keyPairDocument, new ReplaceOptions().upsert(true));
    }

    private Document getSSHKeyPairDBQuery(String regionId, String keyName) {
        Document basicDBObject = new Document(FieldNames.SSH_KEY_PAIR_REGION_ID.name(), (Object)regionId.toString());
        basicDBObject.put(FieldNames.SSH_KEY_PAIR_NAME.name(), (Object)keyName);
        return basicDBObject;
    }

    @Override
    public void removeSSHKeyPair(String regionId, String keyName) {
        Document basicDBObject = this.getSSHKeyPairDBQuery(regionId, keyName);
        this.db.getCollection(CollectionNames.SSH_KEY_PAIRS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)basicDBObject);
    }
}

