/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.rest;

import com.sap.sse.common.Util;
import com.sap.sse.impl.Activator;
import com.sap.sse.rest.CORSFilterConfiguration;
import java.util.HashMap;
import java.util.Map;

public interface CORSAndCSPHeaderProvider {
    default public Map<String, String> getCORSAndCSPHeaders(String origin) {
        String allowOrigin;
        HashMap<String, String> responseCORSHeaders = new HashMap<String, String>();
        CORSFilterConfiguration corsFilterConfiguration = Activator.getInstance().getCORSFilterConfiguration();
        if (corsFilterConfiguration.isWildcard()) {
            allowOrigin = "*";
        } else {
            Iterable<String> origins = corsFilterConfiguration.getOrigins();
            responseCORSHeaders.put("Content-Security-Policy", "frame-ancestors 'self' " + Util.joinStrings((String)" ", origins) + ";");
            allowOrigin = corsFilterConfiguration.contains(origin) ? origin : null;
        }
        if (allowOrigin != null) {
            responseCORSHeaders.put("Access-Control-Allow-Origin", allowOrigin);
            responseCORSHeaders.put("Vary", "Origin");
        }
        responseCORSHeaders.put("Access-Control-Allow-Credentials", "true");
        responseCORSHeaders.put("Access-Control-Allow-Headers", "Authorization, Origin, X-Requested-With, Content-Type");
        responseCORSHeaders.put("Access-Control-Expose-Headers", "Location, Content-Disposition");
        responseCORSHeaders.put("Access-Control-Allow-Methods", "POST, PUT, GET, DELETE, HEAD, OPTIONS");
        return responseCORSHeaders;
    }
}

