/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.formfactor;

import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Window;
import com.sap.sse.gwt.client.formfactor.DeviceCategory;
import java.util.logging.Logger;

public class DeviceDetector {
    private static Logger LOG = Logger.getLogger(DeviceDetector.class.getName());
    private static final RegExp isMobileRegExp = RegExp.compile((String)"Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini|Mobile Safari", (String)"i");
    private static final RegExp tabletBlacklistRegExp = RegExp.compile((String)"iPad|Nexus 7|Nexus 10|Nexus 9|Ryu|PlayBook|KFAPWI|FZ-B|SGP|GT-P|SM-T|SM-P|Tablet", (String)"i");
    private static DeviceCategory deviceCategory;

    public static DeviceCategory getDeviceCategory() {
        if (deviceCategory == null) {
            deviceCategory = DeviceDetector.calculateDeviceCategory();
        }
        return deviceCategory;
    }

    private static DeviceCategory calculateDeviceCategory() {
        DeviceCategory result;
        boolean isMobile = isMobileRegExp.test(Window.Navigator.getUserAgent());
        LOG.info("Navigator user agent matched mobile regex: " + isMobile);
        if (!isMobile) {
            result = DeviceCategory.DESKTOP;
        } else {
            boolean isTablet = tabletBlacklistRegExp.test(Window.Navigator.getUserAgent());
            LOG.info("Navigator user agent matched tablet regex: " + isTablet);
            result = isTablet ? DeviceCategory.TABLET : DeviceCategory.MOBILE;
        }
        return result;
    }

    public static boolean isMobile() {
        return DeviceDetector.getDeviceCategory() == DeviceCategory.MOBILE;
    }

    public static boolean isTablet() {
        return DeviceDetector.getDeviceCategory() == DeviceCategory.TABLET;
    }

    public static boolean isDesktop() {
        return DeviceDetector.getDeviceCategory() == DeviceCategory.DESKTOP;
    }
}

