/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.DummyMarkPassingWithTimePointOnly;
import com.sap.sailing.domain.tracking.impl.MarkPassingImpl;
import com.sap.sailing.domain.tracking.impl.TrackedLegOfCompetitorImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public abstract class AbstractRaceRankComparator<C extends Comparable<C>>
implements Comparator<Competitor> {
    private static final Logger logger = Logger.getLogger(AbstractRaceRankComparator.class.getName());
    private final TrackedRace trackedRace;
    private final TimePoint timePoint;
    private final DummyMarkPassingWithTimePointOnly markPassingWithTimePoint;
    private final boolean lessIsBetter;
    private final ConcurrentMap<Competitor, MarkPassing> lastMarkPassingBeforeTimePoint;
    private final ConcurrentMap<Competitor, TrackedLegOfCompetitor> currentLeg;
    private final MarkPassing NULL_MARK_PASSING = new MarkPassingImpl(null, null, null);
    private final TrackedLegOfCompetitor NULL_TRACKED_LEG_OF_COMPETITOR = new TrackedLegOfCompetitorImpl(null, null, null);

    public AbstractRaceRankComparator(TrackedRace trackedRace, TimePoint timePoint, boolean lessIsBetter) {
        this.trackedRace = trackedRace;
        this.timePoint = timePoint;
        this.markPassingWithTimePoint = new DummyMarkPassingWithTimePointOnly(timePoint);
        this.lessIsBetter = lessIsBetter;
        this.lastMarkPassingBeforeTimePoint = new ConcurrentHashMap<Competitor, MarkPassing>();
        this.currentLeg = new ConcurrentHashMap<Competitor, TrackedLegOfCompetitor>();
    }

    protected TimePoint getTimePoint() {
        return this.timePoint;
    }

    protected TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    private Util.Pair<MarkPassing, TrackedLegOfCompetitor> getLastMarkPassingBeforeTimePointAndCurrentLeg(Competitor competitor) {
        TrackedLegOfCompetitor currentLegForCompetitor;
        MarkPassing lastMarkPassingBeforeTimePointForCompetitor;
        if (this.lastMarkPassingBeforeTimePoint.containsKey(competitor)) {
            MarkPassing markPassingFromMap = (MarkPassing)this.lastMarkPassingBeforeTimePoint.get(competitor);
            lastMarkPassingBeforeTimePointForCompetitor = markPassingFromMap == this.NULL_MARK_PASSING ? null : markPassingFromMap;
            TrackedLegOfCompetitor trackedLegOfCompetitorFromMap = (TrackedLegOfCompetitor)this.currentLeg.get(competitor);
            currentLegForCompetitor = trackedLegOfCompetitorFromMap == this.NULL_TRACKED_LEG_OF_COMPETITOR ? null : trackedLegOfCompetitorFromMap;
        } else {
            NavigableSet<MarkPassing> o1MarkPassings = this.trackedRace.getMarkPassings(competitor);
            this.trackedRace.lockForRead(o1MarkPassings);
            try {
                NavigableSet<MarkPassing> o1MarkPassingsBeforeTimePoint = o1MarkPassings.headSet(this.markPassingWithTimePoint, true);
                int o1MarkPassingsBeforeTimePointSize = o1MarkPassingsBeforeTimePoint.size();
                lastMarkPassingBeforeTimePointForCompetitor = o1MarkPassingsBeforeTimePointSize > 0 ? (MarkPassing)o1MarkPassingsBeforeTimePoint.last() : null;
                currentLegForCompetitor = this.trackedRace.getCurrentLeg(competitor, this.timePoint);
                this.lastMarkPassingBeforeTimePoint.put(competitor, lastMarkPassingBeforeTimePointForCompetitor == null ? this.NULL_MARK_PASSING : lastMarkPassingBeforeTimePointForCompetitor);
                this.currentLeg.put(competitor, currentLegForCompetitor == null ? this.NULL_TRACKED_LEG_OF_COMPETITOR : currentLegForCompetitor);
            }
            finally {
                this.trackedRace.unlockAfterRead(o1MarkPassings);
            }
        }
        return new Util.Pair((Object)lastMarkPassingBeforeTimePointForCompetitor, (Object)currentLegForCompetitor);
    }

    @Override
    public int compare(Competitor o1, Competitor o2) {
        int result;
        if (o1 == o2) {
            result = 0;
        } else {
            Course course = this.trackedRace.getRace().getCourse();
            Util.Pair<MarkPassing, TrackedLegOfCompetitor> lastMarkPassingBeforeTimePointAndCurrentLegForO1 = this.getLastMarkPassingBeforeTimePointAndCurrentLeg(o1);
            MarkPassing o1LastMarkPassingBeforeTimePoint = (MarkPassing)lastMarkPassingBeforeTimePointAndCurrentLegForO1.getA();
            TrackedLegOfCompetitor o1Leg = (TrackedLegOfCompetitor)lastMarkPassingBeforeTimePointAndCurrentLegForO1.getB();
            Util.Pair<MarkPassing, TrackedLegOfCompetitor> lastMarkPassingBeforeTimePointAndCurrentLegForO2 = this.getLastMarkPassingBeforeTimePointAndCurrentLeg(o2);
            MarkPassing o2LastMarkPassingBeforeTimePoint = (MarkPassing)lastMarkPassingBeforeTimePointAndCurrentLegForO2.getA();
            TrackedLegOfCompetitor o2Leg = (TrackedLegOfCompetitor)lastMarkPassingBeforeTimePointAndCurrentLegForO2.getB();
            List legs = course.getLegs();
            int n = o1LastMarkPassingBeforeTimePoint == null ? (o2LastMarkPassingBeforeTimePoint == null ? 0 : 1) : (result = o2LastMarkPassingBeforeTimePoint == null ? -1 : course.getIndexOfWaypoint(o2LastMarkPassingBeforeTimePoint.getWaypoint()) - course.getIndexOfWaypoint(o1LastMarkPassingBeforeTimePoint.getWaypoint()));
            if (result == 0 && o1LastMarkPassingBeforeTimePoint != null) {
                assert (o2LastMarkPassingBeforeTimePoint != null);
                if (o1Leg == null) {
                    assert (o2Leg == null);
                    result = o1LastMarkPassingBeforeTimePoint.getTimePoint().compareTo((Object)o2LastMarkPassingBeforeTimePoint.getTimePoint());
                } else {
                    assert (o2Leg != null);
                    if (o1Leg.getLeg() != o2Leg.getLeg()) {
                        logger.finest("Warning: competitors " + o1 + " and " + o2 + " in different legs (" + o1Leg.getLeg() + " and " + o2Leg.getLeg() + ", respectively) although based on their last mark passings before " + this.timePoint + " (" + o1LastMarkPassingBeforeTimePoint + " and " + o2LastMarkPassingBeforeTimePoint + ", respectively) " + "they should be in the same leg");
                        logger.finest("Warning: competitors " + o1 + " and " + o2 + " in different legs (" + o1Leg.getLeg() + " and " + o2Leg.getLeg() + ", respectively) although based on their last mark passings before " + this.timePoint + " (" + o1LastMarkPassingBeforeTimePoint + " and " + o2LastMarkPassingBeforeTimePoint + ", respectively) " + "they should be in the same leg");
                        result = legs.indexOf(o1Leg.getLeg()) - legs.indexOf(o2Leg.getLeg());
                    } else {
                        C wwdtgO1 = this.getComparisonValueForSameLeg(o1);
                        C wwdtgO2 = this.getComparisonValueForSameLeg(o2);
                        result = wwdtgO1 == null ? (wwdtgO2 == null ? 0 : -1) : (wwdtgO2 == null ? 1 : (this.lessIsBetter ? 1 : -1) * wwdtgO1.compareTo(wwdtgO2));
                    }
                }
            }
        }
        return result;
    }

    protected abstract C getComparisonValueForSameLeg(Competitor var1);
}

