/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.orc.ORCPublicCertificateDatabase;
import com.sap.sailing.domain.orc.impl.ORCCertificatesJsonImporter;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import com.sap.sse.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ORCPublicCertificateDatabaseImpl
implements ORCPublicCertificateDatabase {
    private static final Logger logger = Logger.getLogger(ORCPublicCertificateDatabaseImpl.class.getName());
    private static final String USER_NAME = "Sailing_Analytics@sap.com";
    private static final String CREDENTIALS = "QUdIVUJU";
    private static final String ACTION_PARAM_NAME = "action";
    private static final String ACTION_PARAM_VALUE_LIST_CERT = "ListCert";
    private static final String XSLP_PARAM_NAME = "xslp";
    private static final String XSLP_PARAM_VALUE_LIST_CERT = "ListCert.php";
    private static final String COUNTRY_PARAM_NAME = "CountryId";
    private static final String VPP_YEAR_PARAM_NAME = "VPPYear";
    private static final String REF_NO_PARAM_NAME = "RefNo";
    private static final String YACHT_NAME_PARAM_NAME = "YachtName";
    private static final String SAIL_NUMBER_PARAM_NAME = "SailNo";
    private static final String BOAT_CLASS_PARAM_NAME = "Class";
    private static final NameValuePair ACTION_PARAM = new BasicNameValuePair("action", "ListCert");
    private static final NameValuePair XSLP_PARAM = new BasicNameValuePair("xslp", "ListCert.php");
    private static final String SEARCH_URL = "http://data.orc.org/public/WPub.dll";
    private static final String COUNTRY_OVERVIEW_URL = "http://data.orc.org/public/WPub.dll/RMS";
    private static final String SINGLE_CERTIFICATE_DOWNLOAD_URL = "http://data.orc.org/public/WPub.dll?action=DownBoatRMS";
    private static final String ROOT_ELEMENT = "ROOT";
    private static final String DATA_ELEMENT = "DATA";
    private static final String ROW_ELEMENT = "ROW";
    private static final String DXT_SUFFIX = ".dxt";
    private static final DateTimeFormatter[] DATE_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS")};
    private static final DateTimeFormatter[] DATE_FORMATTERS_WITH_ZONE = new DateTimeFormatter[]{DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX")};

    @Override
    public Iterable<ORCPublicCertificateDatabase.CertificateHandle> search(CountryCode issuingCountry, Integer yearOfIssuance, String referenceNumber, String yachtName, String sailNumber, String boatClassName, boolean includeInvalid) throws Exception {
        HashSet<ORCPublicCertificateDatabase.CertificateHandle> result = new HashSet<ORCPublicCertificateDatabase.CertificateHandle>();
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ACTION_PARAM);
        params.add(XSLP_PARAM);
        params.add(new BasicNameValuePair(COUNTRY_PARAM_NAME, issuingCountry == null ? "*" : issuingCountry.getThreeLetterIOCCode()));
        params.add(new BasicNameValuePair(VPP_YEAR_PARAM_NAME, yearOfIssuance == null ? "0" : yearOfIssuance.toString()));
        if (referenceNumber != null) {
            params.add(new BasicNameValuePair(REF_NO_PARAM_NAME, referenceNumber));
        }
        if (yachtName != null) {
            params.add(new BasicNameValuePair(YACHT_NAME_PARAM_NAME, yachtName));
        }
        if (sailNumber != null) {
            params.add(new BasicNameValuePair(SAIL_NUMBER_PARAM_NAME, sailNumber));
        }
        if (boatClassName != null) {
            params.add(new BasicNameValuePair(BOAT_CLASS_PARAM_NAME, boatClassName));
        }
        UrlEncodedFormEntity parametersEntity = new UrlEncodedFormEntity(params);
        HttpPost postRequest = new HttpPost(SEARCH_URL);
        postRequest.setEntity((HttpEntity)parametersEntity);
        this.addAuthorizationHeader((HttpMessage)postRequest);
        logger.fine(() -> "Searching for " + params + "...");
        HttpResponse processorResponse = client.execute((HttpUriRequest)postRequest);
        InputStream content = processorResponse.getEntity().getContent();
        DocumentBuilder builder = XmlUtil.getSecureDocumentBuilderFactory().newDocumentBuilder();
        Document document = builder.parse(content);
        NodeList dataNodes = document.getElementsByTagName(ROOT_ELEMENT).item(0).getChildNodes();
        int dataNodeIndex = 0;
        while (dataNodeIndex < dataNodes.getLength()) {
            Node dataNode = dataNodes.item(dataNodeIndex);
            if (dataNode.getNodeName().equals(DATA_ELEMENT)) {
                NodeList rowNodes = dataNode.getChildNodes();
                int rowNodeIndex = 0;
                while (rowNodeIndex < rowNodes.getLength()) {
                    Node rowNode = rowNodes.item(rowNodeIndex);
                    if (rowNode.getNodeName().equals(ROW_ELEMENT)) {
                        ORCPublicCertificateDatabase.CertificateHandle certificateHandle = this.parseHandle(rowNode);
                        if (includeInvalid || certificateHandle.isValid().booleanValue()) {
                            result.add(certificateHandle);
                        }
                    }
                    ++rowNodeIndex;
                }
            }
            ++dataNodeIndex;
        }
        logger.fine(() -> "Search for " + params + " returned " + result.size() + " results");
        return result;
    }

    @Override
    public Iterable<ORCPublicCertificateDatabase.CountryOverview> getCountriesWithValidCertificates() throws SAXException, IOException, ParserConfigurationException, DOMException, java.text.ParseException {
        HashSet<ORCPublicCertificateDatabase.CountryOverview> result = new HashSet<ORCPublicCertificateDatabase.CountryOverview>();
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        ArrayList params = new ArrayList();
        HttpGet getRequest = new HttpGet(COUNTRY_OVERVIEW_URL);
        this.addAuthorizationHeader((HttpMessage)getRequest);
        logger.fine(() -> "Searching for " + params + "...");
        HttpResponse processorResponse = client.execute((HttpUriRequest)getRequest);
        InputStream content = processorResponse.getEntity().getContent();
        DocumentBuilder builder = XmlUtil.getSecureDocumentBuilderFactory().newDocumentBuilder();
        Document document = builder.parse(content);
        NodeList dataNodes = document.getElementsByTagName(ROOT_ELEMENT).item(0).getChildNodes();
        int dataNodeIndex = 0;
        while (dataNodeIndex < dataNodes.getLength()) {
            Node dataNode = dataNodes.item(dataNodeIndex);
            if (dataNode.getNodeName().equals(DATA_ELEMENT)) {
                NodeList rowNodes = dataNode.getChildNodes();
                int rowNodeIndex = 0;
                while (rowNodeIndex < rowNodes.getLength()) {
                    ORCPublicCertificateDatabase.CountryOverview countryOverview;
                    Node rowNode = rowNodes.item(rowNodeIndex);
                    if (rowNode.getNodeName().equals(ROW_ELEMENT) && (countryOverview = this.parseCountryOverview(rowNode)).getVPPYear() != null) {
                        result.add(countryOverview);
                    }
                    ++rowNodeIndex;
                }
            }
            ++dataNodeIndex;
        }
        logger.fine(() -> "Search for " + params + " returned " + result.size() + " results");
        return result;
    }

    private ORCPublicCertificateDatabase.CountryOverview parseCountryOverview(Node rowNode) throws DOMException, java.text.ParseException {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmmX");
        CountryCode issuingCountry = null;
        ORCPublicCertificateDatabase.CertificateFamily family = null;
        Integer certType = null;
        Integer vppYear = null;
        int certCount = 0;
        TimePoint lastUpdate = null;
        String certName = null;
        String rmsCode = null;
        int i = 0;
        while (i < rowNode.getChildNodes().getLength()) {
            Node child = rowNode.getChildNodes().item(i);
            switch (child.getNodeName()) {
                case "CountryId": {
                    issuingCountry = CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(child.getTextContent().trim());
                    break;
                }
                case "Family": {
                    family = Util.hasLength((String)child.getTextContent().trim()) ? ORCPublicCertificateDatabase.CertificateFamily.fromId(Integer.valueOf(child.getTextContent().trim())) : null;
                    break;
                }
                case "CertType": {
                    certType = child.getTextContent().trim().isEmpty() ? null : Integer.valueOf(child.getTextContent().trim());
                    break;
                }
                case "VPPYear": {
                    vppYear = child.getTextContent().trim().isEmpty() ? null : Integer.valueOf(child.getTextContent().trim());
                    break;
                }
                case "CertCount": {
                    certCount = Integer.valueOf(child.getTextContent().trim());
                    break;
                }
                case "LastUpdate": {
                    lastUpdate = TimePoint.of((Date)isoDateFormat.parse(child.getTextContent().trim()));
                    break;
                }
                case "CertName": {
                    certName = child.getTextContent().trim();
                    break;
                }
                case "RMSCode": {
                    rmsCode = child.getTextContent().trim();
                }
            }
            ++i;
        }
        return new CountryOverviewImpl(issuingCountry, family, certType, vppYear, certCount, lastUpdate, certName, rmsCode);
    }

    private void addAuthorizationHeader(HttpMessage httpMessage) {
        httpMessage.addHeader("Authorization", "Basic " + new String(Base64.getEncoder().encode(("Sailing_Analytics@sap.com:" + ORCPublicCertificateDatabaseImpl.getDecodedCredentials()).getBytes())));
    }

    private ORCPublicCertificateDatabase.CertificateHandle parseHandle(Node rowNode) throws DOMException, java.text.ParseException {
        assert (rowNode.getNodeName().equals(ROW_ELEMENT));
        CountryCode issuingCountry = null;
        String fileId = null;
        String sssid = null;
        Double gph = null;
        UUID datInGID = null;
        String referenceNumber = null;
        ORCPublicCertificateDatabase.CertificateFamily family = ORCPublicCertificateDatabase.CertificateFamily.UNKNOWN;
        String yachtName = null;
        String sailNumber = null;
        String boatClassName = null;
        String designer = null;
        String builder = null;
        Integer yearBuilt = null;
        Integer certType = null;
        MillisecondsTimePoint issueDate = null;
        Boolean isOneDesign = null;
        Boolean isProvisional = null;
        Boolean isValid = null;
        int i = 0;
        while (i < rowNode.getChildNodes().getLength()) {
            Node child = rowNode.getChildNodes().item(i);
            switch (child.getNodeName()) {
                case "CountryId": {
                    issuingCountry = CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(child.getTextContent().trim());
                    break;
                }
                case "SSSID": {
                    sssid = child.getTextContent();
                    break;
                }
                case "GPH": {
                    gph = child.getTextContent().trim().isEmpty() ? null : Double.valueOf(child.getTextContent().trim());
                    break;
                }
                case "DatInGID": {
                    datInGID = UUID.fromString(child.getTextContent().trim().replaceAll("[{}]", ""));
                    break;
                }
                case "RefNo": {
                    referenceNumber = child.getTextContent().trim();
                    break;
                }
                case "Family": {
                    family = child.getTextContent().trim().isEmpty() ? ORCPublicCertificateDatabase.CertificateFamily.UNKNOWN : ORCPublicCertificateDatabase.CertificateFamily.fromId(Integer.valueOf(child.getTextContent().trim()));
                    break;
                }
                case "YachtName": {
                    yachtName = child.getTextContent();
                    break;
                }
                case "SailNo": {
                    sailNumber = child.getTextContent();
                    break;
                }
                case "Class": {
                    boatClassName = child.getTextContent();
                    break;
                }
                case "Designer": {
                    designer = child.getTextContent();
                    break;
                }
                case "Builder": {
                    builder = child.getTextContent();
                    break;
                }
                case "dxtDate": {
                    issueDate = new MillisecondsTimePoint(this.parseDate(child.getTextContent()));
                    break;
                }
                case "dxtName": {
                    String fileIdWithOptionalDxtSuffix = child.getTextContent();
                    fileId = fileIdWithOptionalDxtSuffix.toLowerCase().endsWith(DXT_SUFFIX) ? fileIdWithOptionalDxtSuffix.substring(0, fileIdWithOptionalDxtSuffix.length() - DXT_SUFFIX.length()) : fileIdWithOptionalDxtSuffix;
                    break;
                }
                case "CertType": {
                    certType = Integer.valueOf(child.getTextContent().trim());
                    break;
                }
                case "Age": {
                    yearBuilt = child.getTextContent().trim().isEmpty() ? null : Integer.valueOf(child.getTextContent().trim());
                    break;
                }
                case "IsOd": {
                    isOneDesign = Boolean.valueOf(child.getTextContent());
                    break;
                }
                case "Provisional": {
                    isProvisional = Boolean.valueOf(child.getTextContent());
                    break;
                }
                case "CanSelect": {
                    isValid = Boolean.valueOf(child.getTextContent());
                }
            }
            ++i;
        }
        return new CertificateHandleImpl(issuingCountry, fileId, gph, sssid, datInGID, referenceNumber, family == null ? ORCPublicCertificateDatabase.CertificateFamily.UNKNOWN : family, yachtName, sailNumber, boatClassName, designer, builder, yearBuilt, (TimePoint)issueDate, certType, isOneDesign, isProvisional, isValid);
    }

    @Override
    public Date parseDate(String dateString) throws DateTimeParseException {
        Optional<LocalDateTime> parsedDateWithoutZone = Arrays.asList(DATE_FORMATTERS).stream().map(f -> {
            try {
                return LocalDateTime.parse(dateString, f);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }).filter(out -> out != null).findAny();
        Optional<ZonedDateTime> parsedDateWithZone = Arrays.asList(DATE_FORMATTERS_WITH_ZONE).stream().map(f -> {
            try {
                return ZonedDateTime.parse(dateString, f);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }).filter(out -> out != null).findAny();
        if (parsedDateWithoutZone.isPresent()) {
            LocalDateTime localDateTime = parsedDateWithoutZone.get();
            return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
        }
        if (parsedDateWithZone.isPresent()) {
            ZonedDateTime zonedDateTime = parsedDateWithZone.get();
            return Date.from(zonedDateTime.toInstant());
        }
        logger.fine("Date is not parsable by any of the format :" + dateString);
        throw new DateTimeParseException("Date is not parsable by any of the format", dateString, 0);
    }

    @Override
    public ORCCertificate searchForUpdate(ORCPublicCertificateDatabase.CertificateHandle certificateHandle) throws ClientProtocolException, IOException, ParseException {
        return this.searchForUpdate(certificateHandle.getIssuingCountry(), certificateHandle.getFileId(), certificateHandle.getReferenceNumber());
    }

    @Override
    public ORCCertificate searchForUpdate(ORCCertificate certificate) throws ClientProtocolException, IOException, ParseException {
        return this.searchForUpdate(certificate.getIssuingCountry(), certificate.getFileId(), certificate.getReferenceNumber());
    }

    private ORCCertificate searchForUpdate(CountryCode issuingCountry, String fileId, String existingCertificateRefNo) throws IOException, ParseException, ClientProtocolException {
        logger.fine("Looking for update of certificate with reference number " + existingCertificateRefNo);
        String queryParameters = "ext=json&CountryId=" + issuingCountry.getThreeLetterIOCCode() + "&dxtName=" + fileId + DXT_SUFFIX;
        ORCCertificate result = this.getSingleCertificate(queryParameters);
        if (result == null) {
            logger.info("Couldn't find any valid certificate for that boat");
        } else if (result.getReferenceNumber().equals(existingCertificateRefNo)) {
            logger.info("Found no new certificate; the one with reference number " + existingCertificateRefNo + " is still valid.");
        } else {
            logger.info("Found update for " + existingCertificateRefNo + ": " + result);
        }
        return result;
    }

    @Override
    public ORCCertificate getCertificate(String referenceNumber, ORCPublicCertificateDatabase.CertificateFamily family) throws Exception {
        ORCCertificate result;
        String queryParameters = "ext=json&RefNo=" + referenceNumber + "&family=" + family.getFamilyQueryParamValue();
        logger.fine("Obtaining certificate for reference number " + referenceNumber);
        try {
            result = this.getSingleCertificate(queryParameters);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error trying to find ORC certificate with reference number " + referenceNumber, e);
            result = null;
        }
        if (result == null) {
            logger.info("Couldn't find ORC certificate with reference number " + referenceNumber);
        }
        return result;
    }

    private ORCCertificate getSingleCertificate(String queryParameters) throws IOException, ParseException, ClientProtocolException {
        HttpGet getRequest = new HttpGet("http://data.orc.org/public/WPub.dll?action=DownBoatRMS&" + queryParameters);
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        this.addAuthorizationHeader((HttpMessage)getRequest);
        Iterable<ORCCertificate> certificates = new ORCCertificatesJsonImporter().read(client.execute((HttpUriRequest)getRequest).getEntity().getContent()).getCertificates();
        ORCCertificate result = certificates.iterator().hasNext() ? certificates.iterator().next() : null;
        return result;
    }

    @Override
    public Iterable<ORCCertificate> getCertificates(Iterable<ORCPublicCertificateDatabase.CertificateHandle> handles) throws Exception {
        HashMap<ORCPublicCertificateDatabase.CertificateHandle, FutureTask<ORCCertificate>> futures = new HashMap<ORCPublicCertificateDatabase.CertificateHandle, FutureTask<ORCCertificate>>();
        for (ORCPublicCertificateDatabase.CertificateHandle handle : handles) {
            if (!handle.getReferenceNumber().trim().isEmpty()) {
                FutureTask<ORCCertificate> task = new FutureTask<ORCCertificate>(() -> this.getCertificate(handle.getReferenceNumber(), handle.getFamily()));
                Thread backgroundExecutor = new Thread(task, "ORC certificate background download thread for " + handle.getReferenceNumber());
                backgroundExecutor.setDaemon(true);
                backgroundExecutor.start();
                futures.put(handle, task);
                continue;
            }
            logger.fine("Ignoring handle " + handle + " because it has an empty reference number");
        }
        HashSet<ORCCertificate> result = new HashSet<ORCCertificate>();
        for (Map.Entry e : futures.entrySet()) {
            ORCCertificate certificate = (ORCCertificate)((Future)e.getValue()).get();
            if (certificate != null) {
                logger.fine("Found certificate for handle " + e.getKey());
                result.add(certificate);
                continue;
            }
            logger.fine("Did not find certificate for handle " + e.getKey());
        }
        return result;
    }

    @Override
    public Future<Set<ORCCertificate>> search(String yachtName, String sailNumber, BoatClass boatClass) {
        logger.fine(() -> "Looking for ORC certificate for " + yachtName + "/" + sailNumber + "/" + boatClass);
        FutureTask<Set<ORCCertificate>> result = new FutureTask<Set<ORCCertificate>>(() -> {
            HashSet<ORCCertificate> certificates = new HashSet<ORCCertificate>();
            Iterable<ORCPublicCertificateDatabase.CertificateHandle> certificateHandles = this.fuzzySearchVaryingSailNumberPadding(yachtName, sailNumber, boatClass);
            if (!this.containsValidHandle(certificateHandles)) {
                logger.fine(() -> "Nothing found for " + yachtName + "/" + sailNumber + "/" + boatClass + "; trying by swapping sail number and yacht name");
                certificateHandles = this.fuzzySearchVaryingSailNumberPadding(sailNumber, yachtName, boatClass);
            }
            for (ORCPublicCertificateDatabase.CertificateHandle handle : certificateHandles) {
                ORCCertificate certificate;
                Iterable<ORCCertificate> certificatesFromHandle = this.getCertificates(handle);
                if (!certificatesFromHandle.iterator().hasNext() || (certificate = certificatesFromHandle.iterator().next()) == null) continue;
                certificates.add(certificate);
            }
            return certificates;
        });
        Thread backgroundExecutor = new Thread(result, "ORC certificate background lookup thread for " + yachtName + "/" + sailNumber + "/" + boatClass);
        backgroundExecutor.setDaemon(true);
        backgroundExecutor.start();
        return result;
    }

    private Iterable<ORCPublicCertificateDatabase.CertificateHandle> fuzzySearchVaryingSailNumberPadding(String yachtName, String sailNumber, BoatClass boatClass) throws Exception {
        HashSet<ORCPublicCertificateDatabase.CertificateHandle> result = new HashSet<ORCPublicCertificateDatabase.CertificateHandle>();
        for (String sailNumberVariant : this.getSailNumberVariants(sailNumber)) {
            logger.fine(() -> "Trying sail number variation " + sailNumberVariant);
            Iterable<ORCPublicCertificateDatabase.CertificateHandle> certificateHandles = this.fuzzySearchVaryingBoatClassName(yachtName, sailNumberVariant, boatClass);
            Util.addAll(this.filterValidHandles(certificateHandles), result);
        }
        if (sailNumber != null && result.isEmpty() && (yachtName != null || boatClass != null)) {
            logger.fine(() -> "Nothing found; trying without restricting sail number to " + sailNumber);
            Util.addAll(this.fuzzySearchVaryingBoatClassName(yachtName, null, boatClass), result);
        }
        return result;
    }

    private boolean containsValidHandle(Iterable<ORCPublicCertificateDatabase.CertificateHandle> certificateHandles) {
        return this.filterValidHandles(certificateHandles).iterator().hasNext();
    }

    private Iterable<ORCPublicCertificateDatabase.CertificateHandle> filterValidHandles(Iterable<ORCPublicCertificateDatabase.CertificateHandle> certificateHandles) {
        return Util.filter(certificateHandles, handle -> handle.isValid());
    }

    private Iterable<ORCPublicCertificateDatabase.CertificateHandle> fuzzySearchVaryingBoatClassName(String yachtName, String sailNumber, BoatClass boatClass) throws Exception {
        String successfulBoatClassName = boatClass == null ? null : boatClass.getName();
        Iterable<ORCPublicCertificateDatabase.CertificateHandle> certificateHandles = this.search(null, null, null, yachtName, sailNumber, successfulBoatClassName, false);
        if (!this.containsValidHandle(certificateHandles) && successfulBoatClassName != null) {
            if (yachtName != null || sailNumber != null) {
                logger.fine(() -> "Nothing found; removing boat class name restriction " + boatClass.getName());
                successfulBoatClassName = null;
                certificateHandles = this.search(null, null, null, yachtName, sailNumber, successfulBoatClassName, false);
            } else {
                logger.fine(() -> "No current certificates found for boat class " + boatClass.getName() + " but yacht name and sail number are not specified either; giving up.");
            }
        }
        if (boatClass != null) {
            HashSet<ORCPublicCertificateDatabase.CertificateHandle> restrictedResults = new HashSet<ORCPublicCertificateDatabase.CertificateHandle>();
            for (ORCPublicCertificateDatabase.CertificateHandle handle : this.filterValidHandles(certificateHandles)) {
                BoatClassMasterdata boatClassMasterData = BoatClassMasterdata.resolveBoatClass((String)handle.getBoatClassName());
                if (boatClassMasterData == null || !boatClassMasterData.getDisplayName().equals(boatClass.getName())) continue;
                restrictedResults.add(handle);
            }
            if (!restrictedResults.isEmpty()) {
                certificateHandles = restrictedResults;
            }
        }
        return certificateHandles;
    }

    private Iterable<String> getSailNumberVariants(String sailNumber) {
        Matcher matcher;
        boolean findResult;
        LinkedList<String> result = new LinkedList<String>();
        result.add(sailNumber);
        if (sailNumber != null && (findResult = (matcher = Pattern.compile("[^A-Za-z]*([A-Za-z]*).*([0-9]*).*").matcher(sailNumber)).find())) {
            String country = matcher.group(1);
            String number = matcher.group(2);
            String[] stringArray = new String[]{"% %", "%-%"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String paddingToTry = stringArray[n2];
                result.add(String.valueOf(country) + paddingToTry + number);
                ++n2;
            }
        }
        return result;
    }

    private static String getDecodedCredentials() {
        return new String(Base64.getDecoder().decode(CREDENTIALS));
    }

    private static class CertificateHandleImpl
    implements ORCPublicCertificateDatabase.CertificateHandle {
        private final CountryCode issuingCountry;
        private final String fileId;
        private final String sssid;
        private final Double gph;
        private final UUID datInGID;
        private final String referenceNumber;
        private final ORCPublicCertificateDatabase.CertificateFamily family;
        private final String yachtName;
        private final String sailNumber;
        private final String boatClassName;
        private final String designer;
        private final String builder;
        private final Integer yearBuilt;
        private final TimePoint issueDate;
        private final Integer certType;
        private final Boolean isOneDesign;
        private final Boolean isProvisional;
        private final Boolean isValid;

        public CertificateHandleImpl(CountryCode issuingCountry, String fileId, Double gph, String sssid, UUID datInGID, String referenceNumber, ORCPublicCertificateDatabase.CertificateFamily family, String yachtName, String sailNumber, String boatClassName, String designer, String builder, Integer yearBuilt, TimePoint issueDate, Integer certType, Boolean oneDesign, Boolean isProvisional, Boolean isValid) {
            this.issuingCountry = issuingCountry;
            this.fileId = fileId;
            this.gph = gph;
            this.sssid = sssid;
            this.datInGID = datInGID;
            this.referenceNumber = referenceNumber;
            this.family = family;
            this.yachtName = yachtName;
            this.sailNumber = sailNumber;
            this.boatClassName = boatClassName;
            this.designer = designer;
            this.builder = builder;
            this.yearBuilt = yearBuilt;
            this.issueDate = issueDate;
            this.certType = certType;
            this.isOneDesign = oneDesign;
            this.isProvisional = isProvisional;
            this.isValid = isValid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CertificateHandleImpl other = (CertificateHandleImpl)obj;
            return !(this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber));
        }

        @Override
        public CountryCode getIssuingCountry() {
            return this.issuingCountry;
        }

        @Override
        public String getFileId() {
            return this.fileId;
        }

        @Override
        public Double getGPH() {
            return this.gph;
        }

        @Override
        public String getSSSID() {
            return this.sssid;
        }

        @Override
        public UUID getDatInGID() {
            return this.datInGID;
        }

        @Override
        public String getReferenceNumber() {
            return this.referenceNumber;
        }

        @Override
        public ORCPublicCertificateDatabase.CertificateFamily getFamily() {
            return this.family;
        }

        @Override
        public String getYachtName() {
            return this.yachtName;
        }

        @Override
        public String getSailNumber() {
            return this.sailNumber;
        }

        @Override
        public String getBoatClassName() {
            return this.boatClassName;
        }

        @Override
        public String getDesigner() {
            return this.designer;
        }

        @Override
        public String getBuilder() {
            return this.builder;
        }

        @Override
        public Integer getYearBuilt() {
            return this.yearBuilt;
        }

        @Override
        public TimePoint getIssueDate() {
            return this.issueDate;
        }

        @Override
        public Integer getCertType() {
            return this.certType;
        }

        @Override
        public Boolean isProvisional() {
            return this.isProvisional;
        }

        @Override
        public Boolean isOd() {
            return this.isOneDesign;
        }

        @Override
        public Boolean isValid() {
            return this.isValid;
        }

        public String toString() {
            return "CertificateHandleImpl [issuingCountry=" + this.issuingCountry + ", sssid=" + this.sssid + ", gph=" + this.gph + ", datInGID=" + this.datInGID + ", referenceNumber=" + this.referenceNumber + ", yachtName=" + this.yachtName + ", sailNumber=" + this.sailNumber + ", boatClassName=" + this.boatClassName + ", designer=" + this.designer + ", builder=" + this.builder + ", yearBuilt=" + this.yearBuilt + ", issueDate=" + this.issueDate + ", certType=" + this.certType + ", isOneDesign=" + this.isOneDesign + ", isProvisional=" + this.isProvisional + ", isValid=" + this.isValid + "]";
        }
    }

    private static class CountryOverviewImpl
    implements ORCPublicCertificateDatabase.CountryOverview {
        private final CountryCode issuingCountry;
        private final ORCPublicCertificateDatabase.CertificateFamily family;
        private final Integer certType;
        private final Integer vppYear;
        private final int certCount;
        private final TimePoint lastUpdate;
        private final String certName;
        private final String rmsCode;

        protected CountryOverviewImpl(CountryCode issuingCountry, ORCPublicCertificateDatabase.CertificateFamily family, Integer certType, Integer vppYear, int certCount, TimePoint lastUpdate, String certName, String rmsCode) {
            this.issuingCountry = issuingCountry;
            this.family = family;
            this.certType = certType;
            this.vppYear = vppYear;
            this.certCount = certCount;
            this.lastUpdate = lastUpdate;
            this.certName = certName;
            this.rmsCode = rmsCode;
        }

        @Override
        public CountryCode getIssuingCountry() {
            return this.issuingCountry;
        }

        @Override
        public ORCPublicCertificateDatabase.CertificateFamily getFamily() {
            return this.family;
        }

        @Override
        public Integer getCertType() {
            return this.certType;
        }

        @Override
        public Integer getVPPYear() {
            return this.vppYear;
        }

        @Override
        public int getCertCount() {
            return this.certCount;
        }

        @Override
        public TimePoint getLastUpdate() {
            return this.lastUpdate;
        }

        @Override
        public String getCertName() {
            return this.certName;
        }

        @Override
        public String getRMSCode() {
            return this.rmsCode;
        }
    }
}

