/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.impl.AbstractRaceColumn;
import com.sap.sailing.domain.leaderboard.FlexibleRaceColumn;
import com.sap.sailing.domain.leaderboard.impl.FlexibleLeaderboardImpl;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sse.common.Util;
import java.util.Collections;

public class RaceColumnImpl
extends AbstractRaceColumn
implements FlexibleRaceColumn {
    private static final long serialVersionUID = -7801617988982540470L;
    private String name;
    private boolean medalRace;
    private final RaceExecutionOrderProvider raceExecutionOrderProvider;
    private IsRegattaLike regattaLikeHelper;

    public RaceColumnImpl(String name, boolean medalRace, RaceExecutionOrderProvider raceExecutionOrderProvider) {
        this.name = name;
        this.medalRace = medalRace;
        this.raceExecutionOrderProvider = raceExecutionOrderProvider;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (!Util.equalsWithNull((Object)oldName, (Object)newName)) {
            this.getRaceColumnListeners().notifyListenersAboutRaceColumnNameChanged(this, oldName, newName);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isMedalRace() {
        return this.medalRace;
    }

    @Override
    public void setIsMedalRace(boolean isMedalRace) {
        this.medalRace = isMedalRace;
        this.getRaceColumnListeners().notifyListenersAboutIsMedalRaceChanged(this, this.isMedalRace());
    }

    @Override
    public Iterable<? extends Fleet> getFleets() {
        return Collections.singleton(FlexibleLeaderboardImpl.defaultFleet);
    }

    @Override
    public RaceExecutionOrderProvider getRaceExecutionOrderProvider() {
        return this.raceExecutionOrderProvider;
    }

    @Override
    public void setRegattaLikeHelper(IsRegattaLike regattaLikeHelper) {
        this.regattaLikeHelper = regattaLikeHelper;
    }

    @Override
    public RegattaLog getRegattaLog() {
        if (this.regattaLikeHelper != null) {
            return this.regattaLikeHelper.getRegattaLog();
        }
        return null;
    }
}

