/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.NaturalComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class LeaderboardTotalRankComparator
implements Comparator<Competitor> {
    private final Leaderboard leaderboard;
    private final ScoringScheme scoringScheme;
    private final Map<Util.Pair<Competitor, RaceColumn>, Double> netPointsCache;
    private final Map<Util.Pair<Competitor, RaceColumn>, Double> totalPointsCache;
    private final Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor;
    private final boolean nullScoresAreBetter;
    private final TimePoint timePoint;
    private final Iterable<RaceColumn> raceColumnsToConsider;
    private final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache;
    private final NaturalComparator lastResortNaturalComparator;
    private final Supplier<Map<Competitor, Integer>> competitorsRankedByOpeningSeries;

    public LeaderboardTotalRankComparator(Leaderboard leaderboard, TimePoint timePoint, ScoringScheme scoringScheme, boolean nullScoresAreBetter, Iterable<RaceColumn> raceColumnsToConsider, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        this(leaderboard, timePoint, scoringScheme, nullScoresAreBetter, raceColumnsToConsider, (competitor, raceColumn) -> leaderboard.getTotalPoints((Competitor)competitor, (RaceColumn)raceColumn, timePoint, cache), cache);
    }

    public LeaderboardTotalRankComparator(final Leaderboard leaderboard, final TimePoint timePoint, final ScoringScheme scoringScheme, final boolean nullScoresAreBetter, final Iterable<RaceColumn> raceColumnsToConsider, final BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        this.leaderboard = leaderboard;
        this.timePoint = timePoint;
        this.scoringScheme = scoringScheme;
        this.nullScoresAreBetter = nullScoresAreBetter;
        this.cache = cache;
        this.lastResortNaturalComparator = new NaturalComparator(true);
        this.netPointsCache = new HashMap<Util.Pair<Competitor, RaceColumn>, Double>();
        this.totalPointsCache = new HashMap<Util.Pair<Competitor, RaceColumn>, Double>();
        this.discardedRaceColumnsPerCompetitor = new HashMap<Competitor, Set<RaceColumn>>();
        this.raceColumnsToConsider = raceColumnsToConsider;
        for (Competitor competitor : leaderboard.getCompetitors()) {
            Set<RaceColumn> discardedRaceColumns = leaderboard.getResultDiscardingRule().getDiscardedRaceColumns(competitor, leaderboard, raceColumnsToConsider, timePoint, leaderboard.getScoringScheme());
            this.discardedRaceColumnsPerCompetitor.put(competitor, discardedRaceColumns);
            for (RaceColumn raceColumn : raceColumnsToConsider) {
                Util.Pair key = new Util.Pair((Object)competitor, (Object)raceColumn);
                Double totalPoints = totalPointsSupplier.apply(competitor, raceColumn);
                this.netPointsCache.put((Util.Pair<Competitor, RaceColumn>)key, leaderboard.getNetPoints(competitor, raceColumn, timePoint, discardedRaceColumns, () -> totalPoints));
                this.totalPointsCache.put((Util.Pair<Competitor, RaceColumn>)key, totalPoints);
            }
        }
        this.competitorsRankedByOpeningSeries = new Supplier<Map<Competitor, Integer>>(){
            private volatile Map<Competitor, Integer> openingSeriesRanking = null;

            @Override
            public synchronized Map<Competitor, Integer> get() {
                if (this.openingSeriesRanking == null) {
                    List result = Util.asList(leaderboard.getCompetitors());
                    Collections.sort(result, scoringScheme.getOpeningSeriesRankComparator(raceColumnsToConsider, nullScoresAreBetter, timePoint, leaderboard, totalPointsSupplier, cache));
                    this.openingSeriesRanking = new HashMap<Competitor, Integer>();
                    int i = 0;
                    while (i < result.size()) {
                        this.openingSeriesRanking.put((Competitor)result.get(i), i + 1);
                        ++i;
                    }
                }
                return this.openingSeriesRanking;
            }
        };
    }

    protected Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    @Override
    public int compare(Competitor o1, Competitor o2) {
        ArrayList<Util.Pair<RaceColumn, Double>> o1Scores = new ArrayList<Util.Pair<RaceColumn, Double>>();
        ArrayList<Util.Pair<RaceColumn, Double>> o2Scores = new ArrayList<Util.Pair<RaceColumn, Double>>();
        ArrayList<Util.Pair<RaceColumn, Double>> o1TotalPoints = new ArrayList<Util.Pair<RaceColumn, Double>>();
        ArrayList<Util.Pair<RaceColumn, Double>> o2TotalPoints = new ArrayList<Util.Pair<RaceColumn, Double>>();
        double o1ScoreSum = this.getLeaderboard().getCarriedPoints(o1);
        double o2ScoreSum = this.getLeaderboard().getCarriedPoints(o2);
        Double o1MedalRaceScore = 0.0;
        Double o2MedalRaceScore = 0.0;
        Double o1CarryForwardScoreInMedals = null;
        Double o2CarryForwardScoreInMedals = null;
        boolean needToResetO1ScoreUponNextValidResult = false;
        boolean needToResetO2ScoreUponNextValidResult = false;
        HashMap<Series, Map<Competitor, Fleet>> fleetWithCorrectOrderingForCompetitorBySeries = new HashMap<Series, Map<Competitor, Fleet>>();
        int defaultFleetBasedComparisonResult = 0;
        int numberOfMedalRacesWonO1 = 0;
        boolean clearNumberOfMedalRacesWonByO1UponNextValidMedalRaceScore = false;
        boolean clearNumberOfMedalRacesWonByO2UponNextValidMedalRaceScore = false;
        int numberOfMedalRacesWonO2 = 0;
        int zeroBasedIndexOfLastMedalSeriesInWhichO1Scored = -1;
        int zeroBasedIndexOfLastMedalSeriesInWhichO2Scored = -1;
        for (RaceColumn raceColumn2 : this.raceColumnsToConsider) {
            int preemptiveColumnResult;
            Double o2Score;
            Double o1Score;
            needToResetO1ScoreUponNextValidResult = needToResetO1ScoreUponNextValidResult || raceColumn2.isStartsWithZeroScore();
            needToResetO2ScoreUponNextValidResult = needToResetO2ScoreUponNextValidResult || raceColumn2.isStartsWithZeroScore();
            boolean o1ValidInNetScore = this.getLeaderboard().getScoringScheme().isValidInNetScore(this.getLeaderboard(), raceColumn2, o1, this.timePoint);
            boolean o2ValidInNetScore = this.getLeaderboard().getScoringScheme().isValidInNetScore(this.getLeaderboard(), raceColumn2, o2, this.timePoint);
            if (o1ValidInNetScore) {
                Double o1Total;
                Util.Pair key = new Util.Pair((Object)o1, (Object)raceColumn2);
                o1Score = this.netPointsCache.get(key);
                if (o1Score != null) {
                    o1Scores.add((Util.Pair<RaceColumn, Double>)new Util.Pair((Object)raceColumn2, (Object)o1Score));
                    if (needToResetO1ScoreUponNextValidResult) {
                        o1ScoreSum = 0.0;
                        needToResetO1ScoreUponNextValidResult = false;
                    }
                    o1ScoreSum += o1Score.doubleValue();
                }
                if ((o1Total = this.totalPointsCache.get(key)) != null) {
                    o1TotalPoints.add(new Util.Pair((Object)raceColumn2, (Object)o1Total));
                }
            } else {
                o1Score = null;
            }
            if (o2ValidInNetScore) {
                Double o2Total;
                Util.Pair key = new Util.Pair((Object)o2, (Object)raceColumn2);
                o2Score = this.netPointsCache.get(key);
                if (o2Score != null) {
                    o2Scores.add((Util.Pair<RaceColumn, Double>)new Util.Pair((Object)raceColumn2, (Object)o2Score));
                    if (needToResetO2ScoreUponNextValidResult) {
                        o2ScoreSum = 0.0;
                        needToResetO2ScoreUponNextValidResult = false;
                    }
                    o2ScoreSum += o2Score.doubleValue();
                }
                if ((o2Total = this.totalPointsCache.get(key)) != null) {
                    o2TotalPoints.add(new Util.Pair((Object)raceColumn2, (Object)o2Total));
                }
            } else {
                o2Score = null;
            }
            if (!o1ValidInNetScore || !o2ValidInNetScore) continue;
            if (raceColumn2.isMedalRace()) {
                if (!raceColumn2.isCarryForward()) {
                    if (o1Score != null) {
                        o1MedalRaceScore = o1MedalRaceScore + o1Score;
                    }
                    if (o2Score != null) {
                        o2MedalRaceScore = o2MedalRaceScore + o2Score;
                    }
                } else {
                    o1CarryForwardScoreInMedals = o1Score;
                    o2CarryForwardScoreInMedals = o2Score;
                }
                if (raceColumn2 instanceof RaceColumnInSeries && this.scoringScheme.isParticipatingInMedalRace(o1, o1Score, (RaceColumnInSeries)raceColumn2, this.competitorsRankedByOpeningSeries)) {
                    zeroBasedIndexOfLastMedalSeriesInWhichO1Scored = this.getZeroBasedIndexOfSeries((RaceColumnInSeries)raceColumn2);
                }
                if (raceColumn2 instanceof RaceColumnInSeries && this.scoringScheme.isParticipatingInMedalRace(o2, o2Score, (RaceColumnInSeries)raceColumn2, this.competitorsRankedByOpeningSeries)) {
                    zeroBasedIndexOfLastMedalSeriesInWhichO2Scored = this.getZeroBasedIndexOfSeries((RaceColumnInSeries)raceColumn2);
                }
                if (this.scoringScheme.isMedalWinAmountCriteria()) {
                    Util.Pair<Integer, Boolean> o1Result = this.leaderboard.getScoringScheme().getNewNumberOfMedalRacesWon(numberOfMedalRacesWonO1, clearNumberOfMedalRacesWonByO1UponNextValidMedalRaceScore, this.leaderboard, o1, raceColumn2, this.timePoint, competitor -> this.totalPointsCache.get(new Util.Pair(competitor, (Object)raceColumn2)), this.cache);
                    Util.Pair<Integer, Boolean> o2Result = this.leaderboard.getScoringScheme().getNewNumberOfMedalRacesWon(numberOfMedalRacesWonO2, clearNumberOfMedalRacesWonByO2UponNextValidMedalRaceScore, this.leaderboard, o2, raceColumn2, this.timePoint, competitor -> this.totalPointsCache.get(new Util.Pair(competitor, (Object)raceColumn2)), this.cache);
                    numberOfMedalRacesWonO1 = (Integer)o1Result.getA();
                    clearNumberOfMedalRacesWonByO1UponNextValidMedalRaceScore = (Boolean)o1Result.getB();
                    numberOfMedalRacesWonO2 = (Integer)o2Result.getA();
                    clearNumberOfMedalRacesWonByO2UponNextValidMedalRaceScore = (Boolean)o2Result.getB();
                }
            }
            if (!raceColumn2.isTotalOrderDefinedByFleet()) continue;
            FleetComparisonResult compareByFleetResult = this.compareByFleet(raceColumn2, o1, o2, fleetWithCorrectOrderingForCompetitorBySeries);
            if (compareByFleetResult.getAuthoritativeFleetComparisonResult() != null) {
                preemptiveColumnResult = compareByFleetResult.getAuthoritativeFleetComparisonResult();
                defaultFleetBasedComparisonResult = 0;
            } else {
                if (defaultFleetBasedComparisonResult == 0) {
                    defaultFleetBasedComparisonResult = compareByFleetResult.getDefaultFleetComparisonResultBasedOnUnknownFleetAssignment();
                }
                preemptiveColumnResult = 0;
            }
            if (preemptiveColumnResult == 0) continue;
            return preemptiveColumnResult;
        }
        int result = this.scoringScheme.compareByMedalRaceParticipation(zeroBasedIndexOfLastMedalSeriesInWhichO1Scored, zeroBasedIndexOfLastMedalSeriesInWhichO2Scored);
        if (result == 0 && (result = defaultFleetBasedComparisonResult) == 0 && (result = this.scoringScheme.compareByNumberOfRacesScored(o1Scores.size(), o2Scores.size())) == 0) {
            if (this.scoringScheme.isMedalWinAmountCriteria()) {
                result = this.scoringScheme.compareByMedalRacesWon(numberOfMedalRacesWonO1, numberOfMedalRacesWonO2);
            }
            if (result == 0 && (result = this.scoringScheme.compareByScoreSum(o1, o1Scores, o1ScoreSum, o2, o2Scores, o2ScoreSum, this.nullScoresAreBetter, zeroBasedIndexOfLastMedalSeriesInWhichO1Scored >= 0 || zeroBasedIndexOfLastMedalSeriesInWhichO2Scored >= 0, this.competitorsRankedByOpeningSeries)) == 0) {
                if (this.scoringScheme.isCarryForwardInMedalsCriteria()) {
                    result = this.scoringScheme.compareBySingleRaceColumnScore(o1CarryForwardScoreInMedals, o2CarryForwardScoreInMedals, this.nullScoresAreBetter);
                }
                if (result == 0 && (result = this.scoringScheme.compareByLastMedalRacesCriteria(o1, o1Scores, o2, o2Scores, this.nullScoresAreBetter, this.leaderboard, this.raceColumnsToConsider, (competitor, raceColumn) -> this.totalPointsCache.get(new Util.Pair(competitor, raceColumn)), this.cache, this.timePoint, zeroBasedIndexOfLastMedalSeriesInWhichO1Scored, numberOfMedalRacesWonO1, numberOfMedalRacesWonO2)) == 0 && (result = this.scoringScheme.compareByMedalRaceScore(o1MedalRaceScore, o2MedalRaceScore, this.nullScoresAreBetter)) == 0 && (result = this.scoringScheme.compareByBetterScore(o1, Collections.unmodifiableList(o1TotalPoints), o2, Collections.unmodifiableList(o2TotalPoints), this.raceColumnsToConsider, this.nullScoresAreBetter, this.timePoint, this.leaderboard, Collections.unmodifiableMap(this.discardedRaceColumnsPerCompetitor), (competitor1, raceColumn1) -> this.totalPointsCache.get(new Util.Pair(competitor1, raceColumn1)), this.cache)) == 0 && (result = this.scoringScheme.compareByLastRace(o1TotalPoints, o2TotalPoints, this.nullScoresAreBetter, o1, o2, this.timePoint, this.cache)) == 0 && (result = this.scoringScheme.compareByLatestRegattaInMetaLeaderboard(this.getLeaderboard(), o1, o2, this.timePoint)) == 0) {
                    if (this.getLeaderboard() instanceof RegattaLeaderboardWithOtherTieBreakingLeaderboard) {
                        result = this.scoringScheme.compareByOtherTieBreakingLeaderboard((RegattaLeaderboardWithOtherTieBreakingLeaderboard)this.getLeaderboard(), o1, o2, this.timePoint);
                    }
                    if (result == 0) {
                        result = this.compareByArbitraryButStableCriteria(o1, o2);
                    }
                }
            }
        }
        return result;
    }

    private int getZeroBasedIndexOfSeries(RaceColumnInSeries raceColumnInSeries) {
        Series medalSeries = raceColumnInSeries.getSeries();
        return Util.indexOf(medalSeries.getRegatta().getSeries(), (Object)medalSeries);
    }

    private int compareByArbitraryButStableCriteria(Competitor o1, Competitor o2) {
        return this.lastResortNaturalComparator.compare(o1.getStableLastResortOrderingCriterion(), o2.getStableLastResortOrderingCriterion());
    }

    private FleetComparisonResult compareByFleet(RaceColumn raceColumn, Competitor o1, Competitor o2, Map<Series, Map<Competitor, Fleet>> fleetWithCorrectOrderingForCompetitorBySeries) {
        Fleet o1f = this.getAFleetWithCorrectOrderingOfCompetitorFromCacheOrRaceColumnAndCache(raceColumn, o1, fleetWithCorrectOrderingForCompetitorBySeries);
        Fleet o2f = this.getAFleetWithCorrectOrderingOfCompetitorFromCacheOrRaceColumnAndCache(raceColumn, o2, fleetWithCorrectOrderingForCompetitorBySeries);
        FleetComparisonResult result = o1f != null ? (o2f != null ? new FleetComparisonResult(o1f.compareTo((Object)o2f), 0) : new FleetComparisonResult(null, this.extremeFleetComparison(raceColumn, o1f))) : (o2f != null ? new FleetComparisonResult(null, -this.extremeFleetComparison(raceColumn, o2f)) : new FleetComparisonResult(null, 0));
        return result;
    }

    private Fleet getAFleetWithCorrectOrderingOfCompetitorFromCacheOrRaceColumnAndCache(RaceColumn raceColumn, Competitor competitor, Map<Series, Map<Competitor, Fleet>> fleetWithCorrectOrderingForCompetitorBySeries) {
        Fleet fleetWithCorrectOrdering = null;
        Series series = raceColumn instanceof RaceColumnInSeries ? ((RaceColumnInSeries)raceColumn).getSeries() : null;
        Map<Competitor, Fleet> fleetForCompetitorInSeries = fleetWithCorrectOrderingForCompetitorBySeries.get(series);
        if (fleetForCompetitorInSeries != null && fleetForCompetitorInSeries.containsKey(competitor)) {
            fleetWithCorrectOrdering = fleetForCompetitorInSeries.get(competitor);
        }
        if (fleetWithCorrectOrdering == null) {
            fleetWithCorrectOrdering = this.getFleetOfCompetitorFromRaceColumnAndCache(raceColumn, competitor, fleetWithCorrectOrderingForCompetitorBySeries, series, fleetForCompetitorInSeries);
        }
        return fleetWithCorrectOrdering;
    }

    private Fleet getFleetOfCompetitorInRaceColumn(RaceColumn raceColumn, Competitor competitor) {
        for (Fleet fleet : raceColumn.getFleets()) {
            if (!Util.contains(this.getLeaderboard().getAllCompetitors(raceColumn, fleet), (Object)competitor)) continue;
            return fleet;
        }
        return null;
    }

    private Fleet getFleetOfCompetitorFromRaceColumnAndCache(RaceColumn raceColumn, Competitor competitor, Map<Series, Map<Competitor, Fleet>> orderedFleetsForCompetitorsBySeries, Series series, Map<Competitor, Fleet> fleetForCompetitorInSeries) {
        Fleet fleetWithCorrectOrdering = this.getFleetOfCompetitorInRaceColumn(raceColumn, competitor);
        if (fleetWithCorrectOrdering != null) {
            if (fleetForCompetitorInSeries == null) {
                fleetForCompetitorInSeries = new HashMap<Competitor, Fleet>();
                orderedFleetsForCompetitorsBySeries.put(series, fleetForCompetitorInSeries);
            }
            fleetForCompetitorInSeries.put(competitor, fleetWithCorrectOrdering);
        }
        return fleetWithCorrectOrdering;
    }

    /*
     * WARNING - void declaration
     */
    private int extremeFleetComparison(RaceColumn raceColumn, Fleet fleet) {
        void var6_10;
        boolean greaterFleetExists = false;
        boolean lesserFleetExists = false;
        boolean othersExist = false;
        for (Fleet fleet2 : raceColumn.getFleets()) {
            if (fleet2 == fleet) continue;
            othersExist = true;
            greaterFleetExists = greaterFleetExists || fleet2.compareTo((Object)fleet) > 0;
            boolean bl = lesserFleetExists = lesserFleetExists || fleet2.compareTo((Object)fleet) < 0;
        }
        if (othersExist && (greaterFleetExists || lesserFleetExists)) {
            int n = -1;
        } else {
            boolean bl = false;
        }
        return (int)var6_10;
    }

    protected Comparator<Double> getScoreComparator() {
        return this.scoringScheme.getScoreComparator(this.nullScoresAreBetter);
    }

    protected int compareByScoreSum(double o1ScoreSum, double o2ScoreSum) {
        return this.getScoreComparator().compare(o1ScoreSum, o2ScoreSum);
    }

    private static class FleetComparisonResult {
        private final Integer authoritativeFleetComparisonResult;
        private final int defaultFleetComparisonResultBasedOnUnknownFleetAssignment;

        public FleetComparisonResult(Integer authoritativeFleetComparisonResult, int defaultFleetComparisonResultBasedOnUnknownFleetAssignment) {
            this.authoritativeFleetComparisonResult = authoritativeFleetComparisonResult;
            this.defaultFleetComparisonResultBasedOnUnknownFleetAssignment = defaultFleetComparisonResultBasedOnUnknownFleetAssignment;
        }

        public Integer getAuthoritativeFleetComparisonResult() {
            return this.authoritativeFleetComparisonResult;
        }

        public int getDefaultFleetComparisonResultBasedOnUnknownFleetAssignment() {
            return this.defaultFleetComparisonResultBasedOnUnknownFleetAssignment;
        }
    }
}

