/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.HighPointFirstGetsFixedScore;
import com.sap.sse.common.TimePoint;
import java.util.concurrent.Callable;

public class HighPointWinnerGetsEightAndInterpolation
extends HighPointFirstGetsFixedScore {
    private static final long serialVersionUID = 4845740206581229807L;
    private static int MAX_NUMBER_OF_COMPETITORS_PER_FLEET = 8;

    public HighPointWinnerGetsEightAndInterpolation() {
        super(MAX_NUMBER_OF_COMPETITORS_PER_FLEET);
    }

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.HIGH_POINT_WINNER_GETS_EIGHT_AND_INTERPOLATION;
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        Double result;
        int effectiveRank = this.getEffectiveRank(raceColumn, competitor, rank);
        if (effectiveRank == 0) {
            result = null;
        } else {
            try {
                Integer numberOfCompetitorsInRace = numberOfCompetitorsInRaceFetcher.call();
                if (numberOfCompetitorsInRace <= MAX_NUMBER_OF_COMPETITORS_PER_FLEET) {
                    double minMaxRange = this.getScoreForRaceWinner() - this.getMinimumScoreFromRank();
                    int numberOfMissingBoatsInFleet = MAX_NUMBER_OF_COMPETITORS_PER_FLEET - numberOfCompetitorsInRace;
                    double score = this.getScoreForRaceWinner() - minMaxRange / (minMaxRange - (double)numberOfMissingBoatsInFleet) * (double)(effectiveRank - 1);
                    result = Math.max(this.getMinimumScoreFromRank(), score);
                } else {
                    result = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

