/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorFactory;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.DelayedLeaderboardCorrections;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.IsManagedByCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DelayedLeaderboardCorrectionsImpl
implements RaceColumnListenerWithDefaultAction,
DelayedLeaderboardCorrections,
IsManagedByCache<SharedDomainFactory<?>> {
    private static final long serialVersionUID = 2652040937315024239L;
    private final Map<Serializable, Double> carriedPointsByCompetitorID;
    private final Map<Serializable, Map<RaceColumn, MaxPointsReason>> maxPointsReasonsByCompetitorID;
    private final Map<Serializable, Map<RaceColumn, Double>> correctedScoresByCompetitorID;
    private final Map<Serializable, Map<RaceColumn, Double>> incrementalScoreCorrectionOffsetsInPointsByCompetitorID;
    private final Map<Serializable, String> displayNamesByCompetitorID;
    private final Set<Serializable> suppressedCompetitorIDs;
    private final Leaderboard leaderboard;
    private transient Set<DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener> listeners;
    private transient CompetitorFactory competitorFactory;

    public DelayedLeaderboardCorrectionsImpl(Leaderboard leaderboard, CompetitorFactory competitorFactory) {
        this.competitorFactory = competitorFactory;
        this.listeners = new HashSet<DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener>();
        this.carriedPointsByCompetitorID = new HashMap<Serializable, Double>();
        this.maxPointsReasonsByCompetitorID = new HashMap<Serializable, Map<RaceColumn, MaxPointsReason>>();
        this.correctedScoresByCompetitorID = new HashMap<Serializable, Map<RaceColumn, Double>>();
        this.incrementalScoreCorrectionOffsetsInPointsByCompetitorID = new HashMap<Serializable, Map<RaceColumn, Double>>();
        this.displayNamesByCompetitorID = new HashMap<Serializable, String>();
        this.suppressedCompetitorIDs = new HashSet<Serializable>();
        this.leaderboard = leaderboard;
        leaderboard.addRaceColumnListener(this);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listeners = new HashSet<DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener>();
    }

    @Override
    public void addLeaderboardCorrectionsResolvedListener(DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLeaderboardCorrectionsResolvedListener(DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    private void assertNoTrackedRaceAssociatedYet() {
        for (RaceColumn raceColumn : this.leaderboard.getRaceColumns()) {
            if (!raceColumn.hasTrackedRaces()) continue;
            throw new IllegalStateException("Can't enqueue competitor name-based state while tracked races are already associated with leaderboard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCarriedPointsByID(Serializable competitorId, double carriedPoints) {
        this.assertNoTrackedRaceAssociatedYet();
        Competitor competitor = this.competitorFactory.getExistingCompetitorById(competitorId);
        if (competitor != null) {
            this.leaderboard.setCarriedPoints(competitor, carriedPoints);
        } else {
            Map<Serializable, Double> map = this.carriedPointsByCompetitorID;
            synchronized (map) {
                this.carriedPointsByCompetitorID.put(competitorId, carriedPoints);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxPointsReasonByID(Serializable competitorId, RaceColumn raceColumn, MaxPointsReason maxPointsReason) {
        this.assertNoTrackedRaceAssociatedYet();
        Competitor competitor = this.competitorFactory.getExistingCompetitorById(competitorId);
        if (competitor != null) {
            this.leaderboard.getScoreCorrection().setMaxPointsReason(competitor, raceColumn, maxPointsReason);
        } else {
            Map<Serializable, Map<RaceColumn, MaxPointsReason>> map = this.maxPointsReasonsByCompetitorID;
            synchronized (map) {
                Map<RaceColumn, MaxPointsReason> map2 = this.maxPointsReasonsByCompetitorID.get(competitorId);
                if (map2 == null) {
                    map2 = new HashMap<RaceColumn, MaxPointsReason>();
                    this.maxPointsReasonsByCompetitorID.put(competitorId, map2);
                }
                map2.put(raceColumn, maxPointsReason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void correctScoreByID(Serializable competitorId, RaceColumn raceColumn, double correctedScore) {
        this.assertNoTrackedRaceAssociatedYet();
        Competitor competitor = this.competitorFactory.getExistingCompetitorById(competitorId);
        if (competitor != null) {
            this.leaderboard.getScoreCorrection().correctScore(competitor, raceColumn, correctedScore);
        } else {
            Map<Serializable, Map<RaceColumn, Double>> map = this.correctedScoresByCompetitorID;
            synchronized (map) {
                Map<RaceColumn, Double> map2 = this.correctedScoresByCompetitorID.get(competitorId);
                if (map2 == null) {
                    map2 = new HashMap<RaceColumn, Double>();
                    this.correctedScoresByCompetitorID.put(competitorId, map2);
                }
                map2.put(raceColumn, correctedScore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void correctScoreIncrementallyByID(Serializable competitorId, RaceColumn raceColumn, double incrementalScoreCorrectionOffsetInPoints) {
        this.assertNoTrackedRaceAssociatedYet();
        Competitor competitor = this.competitorFactory.getExistingCompetitorById(competitorId);
        if (competitor != null) {
            this.leaderboard.getScoreCorrection().correctScoreIncrementally(competitor, raceColumn, incrementalScoreCorrectionOffsetInPoints);
        } else {
            Map<Serializable, Map<RaceColumn, Double>> map = this.incrementalScoreCorrectionOffsetsInPointsByCompetitorID;
            synchronized (map) {
                Map<RaceColumn, Double> map2 = this.incrementalScoreCorrectionOffsetsInPointsByCompetitorID.get(competitorId);
                if (map2 == null) {
                    map2 = new HashMap<RaceColumn, Double>();
                    this.incrementalScoreCorrectionOffsetsInPointsByCompetitorID.put(competitorId, map2);
                }
                map2.put(raceColumn, incrementalScoreCorrectionOffsetInPoints);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignLeftOvers(TrackedRace race) {
        HashMap<String, Competitor> competitorsByName = new HashMap<String, Competitor>();
        HashMap<Serializable, Competitor> competitorsByID = new HashMap<Serializable, Competitor>();
        for (Competitor competitor : race.getRace().getCompetitors()) {
            competitorsByName.put(competitor.getName(), competitor);
            competitorsByID.put(competitor.getId(), competitor);
        }
        Object object = this.carriedPointsByCompetitorID;
        synchronized (object) {
            Iterator<Map.Entry<Serializable, Double>> carryEntryIter = this.carriedPointsByCompetitorID.entrySet().iterator();
            while (carryEntryIter.hasNext()) {
                Map.Entry<Serializable, Double> carryEntry = carryEntryIter.next();
                if (!competitorsByID.containsKey(carryEntry.getKey())) continue;
                this.leaderboard.setCarriedPoints((Competitor)competitorsByID.get(carryEntry.getKey()), carryEntry.getValue());
                carryEntryIter.remove();
            }
        }
        object = this.maxPointsReasonsByCompetitorID;
        synchronized (object) {
            Iterator<Map.Entry<Serializable, Map<RaceColumn, MaxPointsReason>>> maxPointsReasonsEntryIter = this.maxPointsReasonsByCompetitorID.entrySet().iterator();
            while (maxPointsReasonsEntryIter.hasNext()) {
                Map.Entry<Serializable, Map<RaceColumn, MaxPointsReason>> maxPointsReasonEntries = maxPointsReasonsEntryIter.next();
                if (!competitorsByID.containsKey(maxPointsReasonEntries.getKey())) continue;
                for (Map.Entry<RaceColumn, MaxPointsReason> entry : maxPointsReasonEntries.getValue().entrySet()) {
                    this.leaderboard.getScoreCorrection().setMaxPointsReason((Competitor)competitorsByID.get(maxPointsReasonEntries.getKey()), entry.getKey(), entry.getValue());
                }
                maxPointsReasonsEntryIter.remove();
            }
        }
        object = this.correctedScoresByCompetitorID;
        synchronized (object) {
            Iterator<Map.Entry<Serializable, Map<RaceColumn, Double>>> correctedScoresEntryIter = this.correctedScoresByCompetitorID.entrySet().iterator();
            while (correctedScoresEntryIter.hasNext()) {
                Map.Entry<Serializable, Map<RaceColumn, Double>> correctedScoresEntries = correctedScoresEntryIter.next();
                if (!competitorsByID.containsKey(correctedScoresEntries.getKey())) continue;
                for (Map.Entry<RaceColumn, Object> entry : correctedScoresEntries.getValue().entrySet()) {
                    this.leaderboard.getScoreCorrection().correctScore((Competitor)competitorsByID.get(correctedScoresEntries.getKey()), entry.getKey(), (Double)entry.getValue());
                }
                correctedScoresEntryIter.remove();
            }
        }
        object = this.incrementalScoreCorrectionOffsetsInPointsByCompetitorID;
        synchronized (object) {
            Iterator<Map.Entry<Serializable, Map<RaceColumn, Double>>> incrementallyCorrectedScoresEntryIter = this.incrementalScoreCorrectionOffsetsInPointsByCompetitorID.entrySet().iterator();
            while (incrementallyCorrectedScoresEntryIter.hasNext()) {
                Map.Entry<Serializable, Map<RaceColumn, Double>> incrementallyCorrectedScoresEntries = incrementallyCorrectedScoresEntryIter.next();
                if (!competitorsByID.containsKey(incrementallyCorrectedScoresEntries.getKey())) continue;
                for (Map.Entry<RaceColumn, Object> entry : incrementallyCorrectedScoresEntries.getValue().entrySet()) {
                    this.leaderboard.getScoreCorrection().correctScoreIncrementally((Competitor)competitorsByID.get(incrementallyCorrectedScoresEntries.getKey()), entry.getKey(), (Double)entry.getValue());
                }
                incrementallyCorrectedScoresEntryIter.remove();
            }
        }
        object = this.displayNamesByCompetitorID;
        synchronized (object) {
            Iterator<Map.Entry<Serializable, String>> displayNamesEntryIter = this.displayNamesByCompetitorID.entrySet().iterator();
            while (displayNamesEntryIter.hasNext()) {
                Map.Entry<Serializable, String> displayNamesEntry = displayNamesEntryIter.next();
                if (!competitorsByID.containsKey(displayNamesEntry.getKey())) continue;
                this.leaderboard.setDisplayName((Competitor)competitorsByID.get(displayNamesEntry.getKey()), displayNamesEntry.getValue());
                displayNamesEntryIter.remove();
            }
        }
        object = this.suppressedCompetitorIDs;
        synchronized (object) {
            Iterator<Serializable> suppressedCompetitorNameIter = this.suppressedCompetitorIDs.iterator();
            while (suppressedCompetitorNameIter.hasNext()) {
                Serializable next = suppressedCompetitorNameIter.next();
                if (!competitorsByID.containsKey(next)) continue;
                this.leaderboard.setSuppressed((Competitor)competitorsByID.get(next), true);
                suppressedCompetitorNameIter.remove();
            }
        }
        this.removeAsListenerIfNoLeftOvers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAsListenerIfNoLeftOvers() {
        if (this.carriedPointsByCompetitorID.isEmpty() && this.maxPointsReasonsByCompetitorID.isEmpty() && this.correctedScoresByCompetitorID.isEmpty() && this.displayNamesByCompetitorID.isEmpty() && this.suppressedCompetitorIDs.isEmpty()) {
            this.getLeaderboard().removeRaceColumnListener(this);
            Set<DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener> set = this.listeners;
            synchronized (set) {
                for (DelayedLeaderboardCorrections.LeaderboardCorrectionsResolvedListener listener : this.listeners) {
                    listener.correctionsResolved(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayNameByID(Serializable competitorId, String displayName) {
        this.assertNoTrackedRaceAssociatedYet();
        Competitor competitor = this.competitorFactory.getExistingCompetitorById(competitorId);
        if (competitor != null) {
            this.leaderboard.setDisplayName(competitor, displayName);
        } else {
            Map<Serializable, String> map = this.displayNamesByCompetitorID;
            synchronized (map) {
                this.displayNamesByCompetitorID.put(competitorId, displayName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suppressCompetitorByID(Serializable competitorId) {
        this.assertNoTrackedRaceAssociatedYet();
        Competitor competitor = this.competitorFactory.getExistingCompetitorById(competitorId);
        if (competitor != null) {
            this.leaderboard.setSuppressed(competitor, true);
        } else {
            Set<Serializable> set = this.suppressedCompetitorIDs;
            synchronized (set) {
                this.suppressedCompetitorIDs.add(competitorId);
            }
        }
    }

    @Override
    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.assignLeftOvers(trackedRace);
    }

    public IsManagedByCache<SharedDomainFactory<?>> resolve(SharedDomainFactory<?> domainFactory) {
        this.competitorFactory = domainFactory;
        return this;
    }

    @Override
    public void defaultAction() {
    }
}

