/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.common.CourseChange;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithAbstractBearingImpl;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;

public class KilometersPerHourSpeedWithBearingImpl
extends KilometersPerHourSpeedImpl
implements SpeedWithBearing {
    private static final long serialVersionUID = 5749611820871048625L;
    private final Bearing bearing;

    public KilometersPerHourSpeedWithBearingImpl(double speedInKilometersPerHour, Bearing bearing) {
        super(speedInKilometersPerHour);
        this.bearing = bearing;
    }

    public Bearing getBearing() {
        return this.bearing;
    }

    public Position travelTo(Position pos, TimePoint from, TimePoint to) {
        return pos.translateGreatCircle(this.getBearing(), this.travel(from, to));
    }

    public SpeedWithBearing add(SpeedWithBearing other) {
        return AbstractSpeedWithBearingImpl.add((SpeedWithBearing)this, (SpeedWithBearing)other);
    }

    public SpeedWithBearing applyCourseChange(CourseChange courseChange) {
        return AbstractSpeedWithBearingImpl.applyCourseChange((SpeedWithBearing)this, (CourseChange)courseChange);
    }

    public CourseChange getCourseChangeRequiredToReach(SpeedWithBearing targetSpeedWithBearing) {
        return AbstractSpeedWithBearingImpl.getCourseChangeRequiredToReach((SpeedWithBearing)this, (SpeedWithBearing)targetSpeedWithBearing);
    }

    public SpeedWithBearing scale(double d) {
        return super.scale(d);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " to " + this.getBearing().getDegrees() + "\u00b0";
    }

    public int hashCode() {
        return super.hashCode() ^ this.getBearing().hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof SpeedWithBearing && this.getBearing().equals(((SpeedWithBearing)object).getBearing());
    }

    public Speed projectTo(Position position, Bearing projectTo) {
        return AbstractSpeedWithAbstractBearingImpl.projectTo((SpeedWithBearing)this, (Position)position, (Bearing)projectTo);
    }
}

