/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingMessage;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;

public class SwissTimingMessageImpl
implements SwissTimingMessage {
    private final String raceID;
    private final int packetID;
    private final TimePoint timestamp;
    private final int gpsID;
    private final Position position;
    private final Speed speed;
    private final int numberOfSatellites;
    private final int batteryPercent;
    private final int length;

    public SwissTimingMessageImpl(String raceID, int packetID, TimePoint timestamp, int gpsID, Position position, Speed speed, int numberOfSatellites, int batteryPercent, int length) {
        this.raceID = raceID;
        this.packetID = packetID;
        this.timestamp = timestamp;
        this.gpsID = gpsID;
        this.position = position;
        this.speed = speed;
        this.numberOfSatellites = numberOfSatellites;
        this.batteryPercent = batteryPercent;
        this.length = length;
    }

    public boolean isValid() {
        return this.numberOfSatellites > 0 && this.batteryPercent > 0;
    }

    @Override
    public String getRaceID() {
        return this.raceID;
    }

    @Override
    public int getPacketID() {
        return this.packetID;
    }

    @Override
    public TimePoint getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getGpsID() {
        return this.gpsID;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Speed getSpeed() {
        return this.speed;
    }

    @Override
    public int getNumberOfSatellites() {
        return this.numberOfSatellites;
    }

    @Override
    public int getBatteryPercent() {
        return this.batteryPercent;
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        return "#" + this.getPacketID() + "/" + this.getGpsID() + " " + this.getTimestamp() + ": " + this.getPosition() + ", " + this.getSpeed() + ". " + this.getNumberOfSatellites() + " satellites, battery: " + this.getBatteryPercent() + "%";
    }
}

