/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription.chargebee;

import com.sap.sailing.server.gateway.subscription.SubscriptionWebHookHandler;
import com.sap.sailing.server.gateway.subscription.chargebee.SubscriptionWebHookEvent;
import com.sap.sailing.server.gateway.subscription.chargebee.SubscriptionWebHookEventType;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.shared.subscription.chargebee.ChargebeeSubscription;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ChargebeeWebHookHandler
extends SubscriptionWebHookHandler {
    private static final Logger logger = Logger.getLogger(ChargebeeWebHookHandler.class.getName());
    private static final String HANDLER_PATH = "chargebee";

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        SubscriptionWebHookEvent event = null;
        try {
            event = (SubscriptionWebHookEvent)request.getAttribute("event");
            logger.log(Level.INFO, "Handling Webhook Event of type:" + (Object)((Object)event.getEventType()));
            User user = this.getUser(event.getCustomerId());
            if (user != null) {
                if (!this.isOutdatedEvent(event, user)) {
                    this.processEvent(event, user);
                }
                this.sendSuccess(response);
            } else {
                logger.warning("User " + event.getCustomerId() + " not found. Ignoring Chargebee webhook callback for that user.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to proccess Chargebee subscription webhook event " + (event != null ? event.getEventType().getName() : ""), e);
            this.sendFail(response);
        }
    }

    @Override
    public String getHandlerPath() {
        return HANDLER_PATH;
    }

    private boolean isOutdatedEvent(SubscriptionWebHookEvent event, User user) {
        TimePoint occuredAt = event.getEventOccurredAt();
        String subscriptionId = event.getSubscriptionId();
        boolean isOutdated = false;
        if (StringUtils.isNotEmpty((String)subscriptionId)) {
            Subscription subscription = user.getSubscriptionById(subscriptionId);
            if (subscription != null) {
                isOutdated = this.isOutdatedEventTime(occuredAt, subscription);
            } else {
                Iterable subscriptions = user.getSubscriptions();
                if (subscriptions != null) {
                    for (Subscription sub : subscriptions) {
                        if (sub.hasPlan() || !this.isOutdatedEventTime(occuredAt, sub)) continue;
                        isOutdated = true;
                        break;
                    }
                }
            }
        } else {
            Iterable subscriptions = user.getSubscriptions();
            if (subscriptions != null) {
                for (Subscription subscription : subscriptions) {
                    if (!this.isOutdatedEventTime(occuredAt, subscription)) continue;
                    isOutdated = true;
                    break;
                }
            }
        }
        if (isOutdated) {
            logger.info(() -> "Webhook event " + (Object)((Object)event.getEventType()) + " is outdated and won't be processed");
        }
        return isOutdated;
    }

    private boolean isOutdatedEventTime(TimePoint occuredAt, Subscription subscription) {
        return occuredAt.before(subscription.getLatestEventTime()) || occuredAt.before(subscription.getManualUpdatedAt());
    }

    private void processEvent(SubscriptionWebHookEvent event, User user) throws UserManagementException {
        SubscriptionWebHookEventType eventType = event.getEventType();
        if (eventType != null) {
            logger.info(() -> "Start process webhook event \"" + eventType.getName() + "\" for user " + user.getName());
            SecurityService securityService = this.context.getSecurityService();
            securityService.lockSubscriptionsForUser(user);
            try {
                Subscription userSubscription = this.getCurrentUserSubscriptionFromEvent(user, event);
                switch (eventType) {
                    case CUSTOMER_DELETED: {
                        this.updateUserSubscription(user, this.buildEmptySubscription(userSubscription, event));
                        break;
                    }
                    case SUBSCRIPTION_DELETED: {
                        if (userSubscription != null && userSubscription.getSubscriptionId() != null && userSubscription.getSubscriptionId().equals(event.getSubscriptionId())) {
                            this.updateUserSubscription(user, this.buildEmptySubscription(userSubscription, event));
                        }
                        break;
                    }
                    case SUBSCRIPTION_CREATED: 
                    case SUBSCRIPTION_CHANGED: 
                    case SUBSCRIPTION_CANCELLED: 
                    case PAYMENT_SUCCEEDED: 
                    case PAYMENT_FAILED: 
                    case SUBSCRIPTION_ACTIVATED: 
                    case SUBSCRIPTION_PAUSED: 
                    case SUBSCRIPTION_RESUMED: {
                        this.updateUserSubscription(user, this.buildSubscription(userSubscription, event));
                        break;
                    }
                    case PAYMENT_REFUNDED: {
                        if (userSubscription.getInvoiceId() != null && userSubscription.getInvoiceId().equals(event.getInvoiceId())) {
                            this.updateUserSubscription(user, this.buildSubscription(userSubscription, event));
                        }
                        break;
                    }
                    case INVOICE_GENERATED: {
                        this.updateSubscriptionInvoice(user, userSubscription, event);
                        break;
                    }
                    case INVOICE_UPDATED: {
                        if (userSubscription != null && userSubscription.getInvoiceId() != null && userSubscription.getInvoiceId().equals(event.getInvoiceId())) {
                            this.updateSubscriptionInvoice(user, userSubscription, event);
                        }
                        break;
                    }
                    default: {
                        logger.warning(() -> "Webhook event type was unknown and will not be processed ");
                        break;
                    }
                }
            }
            finally {
                securityService.unlockSubscriptionsForUser(user);
            }
            logger.info(() -> "Webhook event \"" + eventType.getName() + "\" has been processed for user " + user.getName());
        }
    }

    private Subscription getCurrentUserSubscriptionFromEvent(User user, SubscriptionWebHookEvent event) {
        Subscription userSubscription = StringUtils.isNotEmpty((String)event.getPlanId()) ? user.getSubscriptionByPlan(event.getPlanId()) : user.getSubscriptionById(event.getSubscriptionId());
        return userSubscription;
    }

    private String getPlanIdFromEvent(SubscriptionWebHookEvent event) {
        String planId = event.getPlanId();
        if (planId == null) {
            String itemPriceId = event.getItemPriceId();
            SubscriptionPlan plan = this.context.getSecurityService().getSubscriptionPlanByItemPriceId(itemPriceId);
            if (plan != null) {
                planId = plan.getId();
            }
        }
        return planId;
    }

    private Subscription buildEmptySubscription(Subscription currentSubscription, SubscriptionWebHookEvent event) {
        return ChargebeeSubscription.createEmptySubscription((String)event.getPlanId(), (TimePoint)event.getEventOccurredAt(), (TimePoint)(currentSubscription != null ? currentSubscription.getManualUpdatedAt() : Subscription.emptyTime()));
    }

    private Subscription buildSubscription(Subscription currentSubscription, SubscriptionWebHookEvent event) {
        String paymentStatus = null;
        String subscriptionStatus = event.getSubscriptionStatus();
        String transactionType = null;
        String transactionStatus = null;
        String invoiceId = null;
        String invoiceStatus = null;
        if (subscriptionStatus != null) {
            transactionType = event.getTransactionType();
            if (transactionType == null && currentSubscription != null) {
                transactionType = currentSubscription.getTransactionType();
            }
            if ((transactionStatus = event.getTransactionStatus()) == null && currentSubscription != null) {
                transactionStatus = currentSubscription.getTransactionStatus();
            }
            Util.Pair<String, String> invoice = this.getInvoiceData(currentSubscription, event);
            invoiceId = (String)invoice.getA();
            invoiceStatus = (String)invoice.getB();
            paymentStatus = ChargebeeSubscription.determinePaymentStatus((String)transactionType, (String)transactionStatus, (String)invoiceStatus);
            if (paymentStatus == null && currentSubscription != null) {
                paymentStatus = currentSubscription.getPaymentStatus();
            }
        }
        return new ChargebeeSubscription(event.getSubscriptionId(), this.getPlanIdFromEvent(event), event.getCustomerId(), event.getSubscriptionTrialStart(), event.getSubscriptionTrialEnd(), subscriptionStatus, paymentStatus, transactionType, transactionStatus, invoiceId, invoiceStatus, event.getReocurringPaymentValue(), event.getCurrencyCode(), event.getSubscriptionCreatedAt(), event.getSubscriptionUpdatedAt(), event.getActivatedAt(), event.getBillingAt(), event.getCurrentTermEnd(), event.getCancelledAt(), event.getEventOccurredAt(), currentSubscription != null ? currentSubscription.getManualUpdatedAt() : Subscription.emptyTime());
    }

    private void updateSubscriptionInvoice(User user, Subscription currentSubscription, SubscriptionWebHookEvent event) throws UserManagementException {
        if (currentSubscription != null && StringUtils.isNotEmpty((String)currentSubscription.getSubscriptionId()) && currentSubscription.getSubscriptionId().equals(event.getInvoiceSubscriptionId()) && StringUtils.isNotEmpty((String)currentSubscription.getCustomerId()) && currentSubscription.getCustomerId().equals(event.getInvoiceCustomerId())) {
            Util.Pair<String, String> invoice = this.getInvoiceData(null, event);
            String invoiceId = (String)invoice.getA();
            String invoiceStatus = (String)invoice.getB();
            String paymentStatus = ChargebeeSubscription.determinePaymentStatusFromInvoiceStatus((String)invoiceStatus);
            ChargebeeSubscription newSubscription = new ChargebeeSubscription(currentSubscription.getSubscriptionId(), currentSubscription.getPlanId(), currentSubscription.getCustomerId(), currentSubscription.getTrialStart(), currentSubscription.getTrialEnd(), currentSubscription.getSubscriptionStatus(), paymentStatus, currentSubscription.getTransactionType(), currentSubscription.getTransactionStatus(), invoiceId, invoiceStatus, currentSubscription.getReoccuringPaymentValue(), currentSubscription.getCurrencyCode(), currentSubscription.getSubscriptionCreatedAt(), currentSubscription.getSubscriptionUpdatedAt(), currentSubscription.getSubscriptionActivatedAt(), currentSubscription.getNextBillingAt(), currentSubscription.getCurrentTermEnd(), currentSubscription.getCancelledAt(), event.getEventOccurredAt(), currentSubscription.getManualUpdatedAt());
            this.updateUserSubscription(user, (Subscription)newSubscription);
        }
    }

    private Util.Pair<String, String> getInvoiceData(Subscription currentSubscription, SubscriptionWebHookEvent event) {
        String invoiceStatus;
        String invoiceId = event.getInvoiceId();
        if (invoiceId == null && currentSubscription != null) {
            invoiceId = currentSubscription.getInvoiceId();
        }
        if ((invoiceStatus = event.getInvoiceStatus()) == null && currentSubscription != null) {
            invoiceStatus = currentSubscription.getInvoiceStatus();
        }
        return new Util.Pair((Object)invoiceId, (Object)invoiceStatus);
    }
}

