/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.orc;

import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.orc.ORCCertificatesCollection;
import com.sap.sailing.domain.orc.ORCCertificatesImporter;
import com.sap.sailing.server.gateway.impl.AbstractFileUploadServlet;
import com.sap.sailing.server.gateway.serialization.racelog.impl.ORCCertificateJsonSerializer;
import com.sap.sse.common.Util;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class ORCCertificateImportServlet
extends AbstractFileUploadServlet {
    private static final long serialVersionUID = -1459007826806652976L;
    private static final Logger logger = Logger.getLogger(ORCCertificateImportServlet.class.getName());

    @Override
    protected void process(List<FileItem> fileItems, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            try {
                HashSet<ORCCertificate> certificates = new HashSet<ORCCertificate>();
                for (FileItem item : fileItems) {
                    if (item.isFormField()) {
                        if (item.getFieldName() == null || !item.getFieldName().equals("certificate_url[]")) continue;
                        Util.addAll(this.parseCertificatesFromUrl(item.getString()), certificates);
                        continue;
                    }
                    ORCCertificatesCollection certificateCollection = ORCCertificatesImporter.INSTANCE.read(item.getInputStream());
                    if (certificateCollection == null) continue;
                    for (ORCCertificate certificate : certificateCollection.getCertificates()) {
                        certificates.add(certificate);
                    }
                }
                this.writeResponse(certificates, resp);
            }
            catch (IOException e) {
                logger.log(Level.INFO, "User " + SessionUtils.getPrincipal() + " was trying to import ORC certificates, but the certificates failed to load", e);
                JSONObject errorResponse = new JSONObject();
                errorResponse.put((Object)"status", (Object)"ERROR");
                errorResponse.put((Object)"message", (Object)("Error trying to import ORC certificates: " + e.getMessage()));
                errorResponse.writeJSONString((Writer)resp.getWriter());
                resp.setStatus(400);
                resp.setContentType("text/html;charset=UTF-8");
            }
            catch (ParseException e) {
                logger.log(Level.INFO, "User " + SessionUtils.getPrincipal() + " was trying to analyze ORC certificates, but the certificates failed to parse", e);
                JSONObject errorResponse = new JSONObject();
                errorResponse.put((Object)"status", (Object)"ERROR");
                errorResponse.put((Object)"message", (Object)("Unable to parse certificate selection: " + e.getMessage()));
                errorResponse.writeJSONString((Writer)resp.getWriter());
                resp.setStatus(400);
                resp.setContentType("text/html;charset=UTF-8");
            }
        }
        finally {
            resp.setContentType("text/html;charset=UTF-8");
        }
    }

    private Iterable<ORCCertificate> parseCertificatesFromUrl(String urlAsString) throws IOException, ParseException {
        if (!urlAsString.contains(":")) {
            urlAsString = "https://" + urlAsString;
        }
        URL url = new URL(urlAsString);
        ORCCertificatesCollection certificates = ORCCertificatesImporter.INSTANCE.read(HttpUrlConnectionHelper.redirectConnection((URL)url).getInputStream());
        HashSet<ORCCertificate> result = new HashSet<ORCCertificate>();
        for (ORCCertificate certificate : certificates.getCertificates()) {
            result.add(certificate);
        }
        return result;
    }

    private void writeResponse(Iterable<ORCCertificate> certificates, HttpServletResponse resp) throws IOException {
        JSONObject jsonResponse = new JSONObject();
        ORCCertificateJsonSerializer certificateSerializer = new ORCCertificateJsonSerializer();
        JSONArray certificatesAsJson = new JSONArray();
        for (ORCCertificate certificate : certificates) {
            certificatesAsJson.add((Object)certificateSerializer.serialize(certificate));
        }
        jsonResponse.put((Object)"certificates", (Object)certificatesAsJson);
        jsonResponse.put((Object)"status", (Object)"OK");
        this.writeJsonIntoHtmlResponse(resp, (JSONAware)jsonResponse);
    }
}

