/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.server.gateway.impl.AbstractFileUploadServlet;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.filestorage.OperationFailedException;
import com.sap.sse.security.SecurityService;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class FileUploadServlet
extends AbstractFileUploadServlet {
    private static final long serialVersionUID = -9002541098579359029L;
    private static final Logger logger = Logger.getLogger(FileUploadServlet.class.getName());
    private static final long MAX_SIZE_IN_MB = 5000L;

    @Override
    protected void process(List<FileItem> fileItems, HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException, IOException {
        JSONArray resultList = new JSONArray();
        SecurityService securityService = this.getSecurityService();
        if (securityService.getCurrentUser() == null) {
            JSONObject noUserError = new JSONObject();
            noUserError.put((Object)"status", (Object)Response.Status.FORBIDDEN.name());
            noUserError.put((Object)"message", (Object)"Must be authenticated to upload file");
            resultList.add((Object)noUserError);
        } else if (!securityService.getCurrentUser().isEmailValidated()) {
            JSONObject noVaidatedEmailAddressError = new JSONObject();
            noVaidatedEmailAddressError.put((Object)"status", (Object)Response.Status.FORBIDDEN.name());
            noVaidatedEmailAddressError.put((Object)"message", (Object)"File upload permitted only with validated e-mail address");
            resultList.add((Object)noVaidatedEmailAddressError);
        }
        for (FileItem fileItem : fileItems) {
            JSONObject result;
            block17: {
                int lastDot;
                String fileName;
                result = new JSONObject();
                String fileNameUnderscoreEncoded = fileName = Paths.get(fileItem.getName(), new String[0]).getFileName().toString();
                String fileType = fileItem.getContentType();
                String fileExtension = fileType.equals("image/jpeg") ? ".jpg" : (fileType.equals("image/png") ? ".png" : (fileType.equals("image/gif") ? ".gif" : ((lastDot = fileName.lastIndexOf(".")) > 0 ? fileName.substring(lastDot).toLowerCase() : "")));
                try {
                    if (fileItem.getSize() > 5242880000L) {
                        String errorMessage = "Image is larger than 5000MB";
                        logger.warning("Ignoring file storage request because file " + fileName + " is larger than " + 5000L + "MB");
                        result.put((Object)"status", (Object)Response.Status.INTERNAL_SERVER_ERROR.name());
                        result.put((Object)"message", (Object)"Image is larger than 5000MB");
                        result.put((Object)"file_size", (Object)fileItem.getSize());
                        break block17;
                    }
                    URI fileUri = this.getService().getFileStorageManagementService().getActiveFileStorageService().storeFile(fileItem.getInputStream(), fileExtension, fileItem.getSize());
                    logger.info("User " + securityService.getCurrentUser().getName() + " uploaded file " + fileName + ", URI " + fileUri);
                    result.put((Object)"file_name", (Object)fileNameUnderscoreEncoded);
                    result.put((Object)"file_uri", (Object)fileUri.toString());
                    result.put((Object)"content_type", (Object)fileItem.getContentType());
                    result.put((Object)"file_size", (Object)fileItem.getSize());
                    if (fileItem.getContentType() == null || !fileItem.getContentType().startsWith("image/")) break block17;
                    Throwable throwable = null;
                    Object var15_18 = null;
                    try (InputStream inputStream = fileItem.getInputStream();){
                        BufferedImage image = ImageIO.read(inputStream);
                        if (image != null) {
                            int height = image.getHeight();
                            int width = image.getWidth();
                            result.put((Object)"media_type_height", (Object)height);
                            result.put((Object)"media_type_width", (Object)width);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (InvalidPropertiesException | OperationFailedException | IOException | RuntimeException e) {
                    String errorMessage = "Could not store file" + (e.getMessage() == null ? "" : ": " + e.getMessage());
                    logger.log(Level.WARNING, "Could not store file", e);
                    result.put((Object)"status", (Object)Response.Status.INTERNAL_SERVER_ERROR.name());
                    result.put((Object)"message", (Object)errorMessage);
                }
            }
            resultList.add((Object)result);
        }
        this.writeJsonIntoHtmlResponse(resp, (JSONAware)resultList);
    }
}

