/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import java.sql.Connection;
import java.sql.SQLException;

public class InsertLegStatsStatement
extends AbstractPreparedInsertStatement<TrackedLegOfCompetitorRankingInfoCacheAndNow> {
    protected InsertLegStatsStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"LegStats\" (\"race\", \"regatta\", \"number\", \"competitorId\", \"rankOneBased\", \"distanceSailedInMeters\", \"elapsedTimeInSeconds\", \"avgCrossTrackErrorInMeters\", \"absoluteAvgCrossTrackErrorInMeters\", \"numberOfTacks\", \"numberOfGybes\", \"numberOfPenaltyCircles\", \"avgVelocityMadeGoodInKnots\", \"gapToLeaderInSeconds\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(TrackedLegOfCompetitorRankingInfoCacheAndNow trackedLegOfCompetitorAndNow) throws SQLException {
        this.getPreparedStatement().setString(1, trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getTrackedLeg().getTrackedRace().getRace().getName());
        this.getPreparedStatement().setString(2, trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getTrackedLeg().getTrackedRace().getTrackedRegatta().getRegatta().getName());
        this.getPreparedStatement().setInt(3, trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getTrackedLeg().getLeg().getZeroBasedIndexOfStartWaypoint());
        this.getPreparedStatement().setString(4, trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getCompetitor().getId().toString());
        this.getPreparedStatement().setInt(5, trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getRank(trackedLegOfCompetitorAndNow.getNow()));
        this.setDouble(6, this.metersOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getDistanceTraveled(trackedLegOfCompetitorAndNow.getNow())));
        this.setDouble(7, this.secondsOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getTime(trackedLegOfCompetitorAndNow.getNow())));
        this.setDouble(8, this.metersOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getAverageSignedCrossTrackError(trackedLegOfCompetitorAndNow.getNow(), false)));
        this.setDouble(9, this.metersOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getAverageAbsoluteCrossTrackError(trackedLegOfCompetitorAndNow.getNow(), false)));
        try {
            this.getPreparedStatement().setInt(10, this.intOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getNumberOfTacks(trackedLegOfCompetitorAndNow.getNow(), false)));
            this.getPreparedStatement().setInt(11, this.intOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getNumberOfJibes(trackedLegOfCompetitorAndNow.getNow(), false)));
            this.getPreparedStatement().setInt(12, this.intOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getNumberOfPenaltyCircles(trackedLegOfCompetitorAndNow.getNow(), false)));
        }
        catch (NoWindException nwe) {
            this.getPreparedStatement().setInt(10, 0);
            this.getPreparedStatement().setInt(11, 0);
            this.getPreparedStatement().setInt(12, 0);
        }
        Speed vmg = trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getAverageVelocityMadeGood(trackedLegOfCompetitorAndNow.getNow());
        this.setDouble(13, vmg == null ? 0.0 : vmg.getKnots());
        this.setDouble(14, this.secondsOr0ForNull(trackedLegOfCompetitorAndNow.getTrackedLegOfCompetitor().getGapToLeader(trackedLegOfCompetitorAndNow.getNow(), WindPositionMode.LEG_MIDDLE, trackedLegOfCompetitorAndNow.getRankingInfo(), trackedLegOfCompetitorAndNow.getCache())));
    }

    static class TrackedLegOfCompetitorRankingInfoCacheAndNow {
        private final TimePoint now;
        private final RankingMetric.RankingInfo rankingInfo;
        private final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache;
        private final TrackedLegOfCompetitor trackedLegOfCompetitor;

        public TrackedLegOfCompetitorRankingInfoCacheAndNow(TimePoint now, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache, TrackedLegOfCompetitor trackedLegOfCompetitor) {
            this.now = now;
            this.rankingInfo = rankingInfo;
            this.cache = cache;
            this.trackedLegOfCompetitor = trackedLegOfCompetitor;
        }

        public TimePoint getNow() {
            return this.now;
        }

        public RankingMetric.RankingInfo getRankingInfo() {
            return this.rankingInfo;
        }

        public WindLegTypeAndLegBearingAndORCPerformanceCurveCache getCache() {
            return this.cache;
        }

        public TrackedLegOfCompetitor getTrackedLegOfCompetitor() {
            return this.trackedLegOfCompetitor;
        }
    }
}

