/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.orc.impl;

import com.sap.sailing.domain.common.orc.AverageWindOnLegCache;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;

public class ORCPerformanceCurveLegImpl
implements ORCPerformanceCurveLeg {
    private static final long serialVersionUID = -1402717786643975976L;
    private final Distance length;
    private final Bearing twa;
    private final ORCPerformanceCurveLegTypes type;

    public ORCPerformanceCurveLegImpl(Distance length, Bearing twa) {
        this.length = length;
        this.twa = twa;
        this.type = ORCPerformanceCurveLegTypes.TWA;
    }

    public ORCPerformanceCurveLegImpl(Distance length, ORCPerformanceCurveLegTypes type) {
        this.length = length;
        this.type = type;
        this.twa = null;
    }

    @Override
    public Distance getLength() {
        return this.length;
    }

    @Override
    public Bearing getTwa() {
        return this.twa;
    }

    @Override
    public Bearing getTwa(AverageWindOnLegCache cache) {
        return this.twa;
    }

    @Override
    public ORCPerformanceCurveLeg scale(double share) {
        Distance scaledLength = this.getLength() == null ? null : this.getLength().scale(share);
        return this.getType() == ORCPerformanceCurveLegTypes.TWA ? new ORCPerformanceCurveLegImpl(scaledLength, this.getTwa()) : new ORCPerformanceCurveLegImpl(scaledLength, this.getType());
    }

    @Override
    public String toString() {
        return "[length=" + this.length.getNauticalMiles() + "NM, " + (this.twa == null ? this.type.name() : "TWA=" + this.twa) + "]";
    }

    @Override
    public ORCPerformanceCurveLegTypes getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        result = 31 * result + (this.twa == null ? 0 : this.twa.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ORCPerformanceCurveLegImpl other = (ORCPerformanceCurveLegImpl)obj;
        if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
            return false;
        }
        if (this.twa == null ? other.twa != null : !this.twa.equals(other.twa)) {
            return false;
        }
        return this.type == other.type;
    }
}

