/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sse.common.TimePoint;

public class ExponentialTimeDifferenceWeigher
implements Weigher<TimePoint> {
    private static final long serialVersionUID = 1832731495731693670L;
    private static final double logHalf = Math.log(0.5);
    private final long halfConfidenceAfterMilliseconds;
    private final double minimumConfidence;

    public ExponentialTimeDifferenceWeigher(long halfConfidenceAfterMilliseconds, double minimumConfidence) {
        this.halfConfidenceAfterMilliseconds = halfConfidenceAfterMilliseconds;
        this.minimumConfidence = minimumConfidence;
    }

    public ExponentialTimeDifferenceWeigher(long halfConfidenceAfterMilliseconds) {
        this(halfConfidenceAfterMilliseconds, 0.0);
    }

    @Override
    public double getConfidence(TimePoint fix, TimePoint request) {
        return Math.max(this.minimumConfidence, Math.exp(logHalf * ((double)Math.abs(request.asMillis() - fix.asMillis()) / (double)this.halfConfidenceAfterMilliseconds)));
    }
}

