/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.confidence.ConfidenceBasedAverager;
import com.sap.sailing.domain.common.confidence.HasConfidence;
import com.sap.sailing.domain.common.confidence.HasConfidenceAndIsScalable;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.HasConfidenceImpl;
import com.sap.sse.common.scalablevalue.ScalableValue;
import java.util.Iterator;

public class ConfidenceBasedAveragerImpl<ValueType, BaseType, RelativeTo>
implements ConfidenceBasedAverager<ValueType, BaseType, RelativeTo> {
    private final Weigher<RelativeTo> weigher;

    public ConfidenceBasedAveragerImpl(Weigher<RelativeTo> weigher) {
        this.weigher = weigher;
    }

    @Override
    public HasConfidence<ValueType, BaseType, RelativeTo> getAverage(Iterable<? extends HasConfidenceAndIsScalable<ValueType, BaseType, RelativeTo>> values, RelativeTo at) {
        return values == null ? null : this.getAverage(values.iterator(), at);
    }

    @Override
    public HasConfidence<ValueType, BaseType, RelativeTo> getAverage(Iterator<? extends HasConfidenceAndIsScalable<ValueType, BaseType, RelativeTo>> values, RelativeTo at) {
        if (values == null || !values.hasNext()) {
            return null;
        }
        ScalableValue numerator = null;
        double confidenceSum = 0.0;
        int count = 0;
        while (values.hasNext()) {
            HasConfidenceAndIsScalable<ValueType, BaseType, RelativeTo> next = values.next();
            double relativeWeight = this.getWeight(next, at);
            ScalableValue weightedNext = next.getScalableValue().multiply(relativeWeight);
            numerator = numerator == null ? weightedNext : numerator.add(weightedNext);
            confidenceSum += relativeWeight;
            ++count;
        }
        double newConfidence = confidenceSum / (double)count;
        Object result = numerator.divide(confidenceSum);
        return new HasConfidenceImpl(result, newConfidence, at);
    }

    protected double getWeight(HasConfidenceAndIsScalable<ValueType, BaseType, RelativeTo> next, RelativeTo at) {
        return (this.getWeigher() == null ? 1.0 : this.getWeigher().getConfidence(next.getRelativeTo(), at)) * next.getConfidence();
    }

    private Weigher<RelativeTo> getWeigher() {
        return this.weigher;
    }
}

