/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingreplayadapter.impl;

import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayListener;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayRace;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayService;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingRaceConfig;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayConnectivityParameters;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayParserImpl;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayRaceImpl;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackerManager;
import com.sap.sse.util.ByteArrayOutputStreamWithVisibleBuffer;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SwissTimingReplayServiceImpl
implements SwissTimingReplayService {
    public static final String RACE_CONFIG_URL_TEMPLATE = "http://ota2.sportresult.com/configuration?_race={0}&effective=1&additional=config";
    private static final String SWISSTIMING_DATEFORMAT_PATTERN = "dd.MM.yyyy HH:mm";
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private final DomainFactory domainFactory;

    public SwissTimingReplayServiceImpl(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
    }

    @Override
    public List<SwissTimingReplayRace> listReplayRaces(String swissTimingUrlText) {
        try {
            URL raceListUrl = new URL(swissTimingUrlText);
            List<SwissTimingReplayRace> races = this.parseJSONObject(raceListUrl.openStream(), swissTimingUrlText);
            return races;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SwissTimingRaceConfig loadRaceConfig(String raceId) {
        try {
            URL configUrl = new URL(MessageFormat.format(RACE_CONFIG_URL_TEMPLATE, raceId));
            URLConnection connection = configUrl.openConnection();
            Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
            InputStream configDataStream = connection.getInputStream();
            return this.loadRaceConfig(configDataStream, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SwissTimingRaceConfig loadRaceConfig(InputStream configDataStream, Charset charset) throws IOException, ParseException {
        JSONObject jsonRaceConfig = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(configDataStream));
        JSONObject jsonConfigEntry = (JSONObject)jsonRaceConfig.get((Object)"config");
        String latitude = (String)jsonRaceConfig.get((Object)"latitude");
        String longitude = (String)jsonRaceConfig.get((Object)"longitude");
        String country_code = (String)jsonRaceConfig.get((Object)"country_code");
        String gmt_offset = (String)jsonRaceConfig.get((Object)"gmt_offset");
        String location = (String)jsonRaceConfig.get((Object)"location");
        String event_name = (String)(jsonConfigEntry != null ? jsonConfigEntry.get((Object)"event_name") : null);
        String race_start_ts = (String)(jsonConfigEntry != null ? jsonConfigEntry.get((Object)"race_start_ts") : null);
        SwissTimingRaceConfig raceConfig = new SwissTimingRaceConfig(latitude, longitude, country_code, gmt_offset, location, event_name, race_start_ts);
        return raceConfig;
    }

    @Override
    public List<SwissTimingReplayRace> parseJSONObject(InputStream inputStream, String swissTimingUrlText) throws IOException, java.text.ParseException, ParseException {
        JSONArray json = (JSONArray)new JSONParser().parse((Reader)new InputStreamReader(inputStream));
        ArrayList<SwissTimingReplayRace> result = new ArrayList<SwissTimingReplayRace>();
        DateFormat startTimeFormat = this.getStartTimeFormat();
        for (Object raceEntry : json) {
            JSONObject jsonRaceEntry = (JSONObject)raceEntry;
            String startTimeText = (String)jsonRaceEntry.get((Object)"start");
            Date startTime = startTimeText == null ? null : startTimeFormat.parse(startTimeText);
            SwissTimingReplayRaceImpl replayRace = new SwissTimingReplayRaceImpl(swissTimingUrlText, (String)jsonRaceEntry.get((Object)"flight_number"), (String)jsonRaceEntry.get((Object)"race_id"), (String)jsonRaceEntry.get((Object)"rsc"), (String)jsonRaceEntry.get((Object)"name"), (String)jsonRaceEntry.get((Object)"class"), startTime, String.valueOf((String)jsonRaceEntry.get((Object)"link")) + "&_start=0");
            result.add(replayRace);
        }
        return result;
    }

    @Override
    public DateFormat getStartTimeFormat() {
        SimpleDateFormat startTimeFormat = new SimpleDateFormat(SWISSTIMING_DATEFORMAT_PATTERN);
        startTimeFormat.setTimeZone(DEFAULT_TIMEZONE);
        return startTimeFormat;
    }

    @Override
    public void loadRaceData(String link, SwissTimingReplayListener replayListener) {
        try {
            int read;
            URL raceDataUrl = link.contains("://") ? new URL(link) : new URL("http://" + link);
            InputStream urlInputStream = (InputStream)HttpUrlConnectionHelper.redirectConnection((URL)raceDataUrl).getContent();
            ByteArrayOutputStreamWithVisibleBuffer bos = new ByteArrayOutputStreamWithVisibleBuffer();
            byte[] buf = new byte[8192];
            while ((read = urlInputStream.read(buf)) != -1) {
                bos.write(buf, 0, read);
            }
            new SwissTimingReplayParserImpl().readData(new ByteArrayInputStream(bos.getBuffer(), 0, bos.size()), replayListener);
            bos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void loadRaceData(RegattaIdentifier regattaToAddTo, String link, String swissTimingUrl, String raceName, String raceID, String boatClassName, TrackerManager trackerManager, TrackedRegattaRegistry trackedRegattaRegistry, boolean useInternalMarkPassingAlgorithm, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws MalformedURLException, FileNotFoundException, URISyntaxException, Exception {
        trackerManager.addRace(regattaToAddTo, (RaceTrackingConnectivityParameters)new SwissTimingReplayConnectivityParameters(link, swissTimingUrl, raceName, raceID, boatClassName, useInternalMarkPassingAlgorithm, this.domainFactory, this, raceLogStore, regattaLogStore), -1L);
    }
}

