/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.kiworesultimport.Boat;
import com.sap.sailing.kiworesultimport.BoatResultInRace;
import com.sap.sailing.kiworesultimport.Crewmember;
import com.sap.sailing.kiworesultimport.RaceSummary;
import com.sap.sailing.kiworesultimport.RegattaSummary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RegattaSummaryAsScoreCorrections
implements RegattaScoreCorrections {
    private final RegattaSummary regattaSummary;
    private final ScoreCorrectionProvider provider;

    public RegattaSummaryAsScoreCorrections(RegattaSummary regattaSummary, ScoreCorrectionProvider provider) {
        this.regattaSummary = regattaSummary;
        this.provider = provider;
    }

    public String getRegattaName() {
        return String.valueOf(this.regattaSummary.getEventName()) + " (" + this.regattaSummary.getBoatClassName() + ")";
    }

    public ScoreCorrectionProvider getProvider() {
        return this.provider;
    }

    public Iterable<RegattaScoreCorrections.ScoreCorrectionsForRace> getScoreCorrectionsForRaces() {
        ArrayList<RegattaScoreCorrections.ScoreCorrectionsForRace> result = new ArrayList<RegattaScoreCorrections.ScoreCorrectionsForRace>();
        for (RaceSummary raceSummary : this.regattaSummary.getRaces()) {
            result.add(new ZipFileScoreCorrectionsForRace(raceSummary));
        }
        return result;
    }

    private class ZipFileScoreCorrectionForCompetitorInRace
    implements RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace {
        private final BoatResultInRace boatResults;
        private final String sailID;
        private final String boatName;

        public ZipFileScoreCorrectionForCompetitorInRace(BoatResultInRace boatResults, String sailID, String boatName) {
            this.boatResults = boatResults;
            this.sailID = sailID;
            this.boatName = boatName;
        }

        public String getSailID() {
            return this.sailID;
        }

        public String getCompetitorName() {
            return this.boatName;
        }

        public Double getPoints() {
            return this.boatResults.getPoints();
        }

        public MaxPointsReason getMaxPointsReason() {
            return this.boatResults.getMaxPointsReason();
        }

        public Boolean isDiscarded() {
            return this.boatResults.isDiscarded();
        }
    }

    private class ZipFileScoreCorrectionsForRace
    implements RegattaScoreCorrections.ScoreCorrectionsForRace {
        private final RaceSummary raceSummary;

        public ZipFileScoreCorrectionsForRace(RaceSummary raceSummary) {
            this.raceSummary = raceSummary;
        }

        public String getRaceNameOrNumber() {
            return "" + this.raceSummary.getRaceNumber();
        }

        public Set<String> getSailIDs() {
            HashSet<String> result = new HashSet<String>();
            for (Boat boat : this.raceSummary.getBoats()) {
                result.add(boat.getSailingNumber());
            }
            return result;
        }

        public RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace getScoreCorrectionForCompetitor(String sailID) {
            ZipFileScoreCorrectionForCompetitorInRace result = null;
            Boat boat = this.raceSummary.getBoat(sailID);
            if (boat != null) {
                String boatName = this.getNameForBoat(boat);
                result = new ZipFileScoreCorrectionForCompetitorInRace(this.raceSummary.getBoatResults(boat), sailID, boatName);
            }
            return result;
        }

        private String getNameForBoat(Boat boat) {
            String result = boat.getName();
            if (result == null || result.trim().length() == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(boat.getCrew().getSkipper().getName());
                for (Crewmember crewmember : boat.getCrew().getCrewmembers()) {
                    sb.append(" + ");
                    sb.append(crewmember.getName());
                }
                result = sb.toString();
            }
            return result;
        }
    }
}

