/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.server.gateway.serialization.racelog.impl.BaseRaceLogEventSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class RaceLogFinishPositioningEventSerializer
extends BaseRaceLogEventSerializer {
    public static final String FIELD_POSITIONED_COMPETITORS = "positionedCompetitors";
    public static final String FIELD_COMPETITOR_ID = "competitorId";
    public static final String FIELD_COMPETITOR_NAME = "competitorName";
    public static final String FIELD_COMPETITOR_SHORT_NAME = "competitorShortName";
    public static final String FIELD_COMPETITOR_BOAT_NAME = "competitorBoatName";
    public static final String FIELD_COMPETITOR_BOAT_SAIL_ID = "competitorBoatSailId";
    public static final String FIELD_SCORE_CORRECTIONS_MAX_POINTS_REASON = "maxPointsReason";
    public static final String FIELD_SCORE = "score";
    public static final String FIELD_COMMENT = "comment";
    public static final String FIELD_MERGE_STATE = "mergeState";
    public static final String FIELD_RANK = "rank";
    public static final String FIELD_FINISHING_TIME_POINT_AS_MILLIS = "finishingTimePointAsMillis";

    public RaceLogFinishPositioningEventSerializer(JsonSerializer<Competitor> competitorSerializer) {
        super(competitorSerializer);
    }

    @Override
    protected abstract String getClassFieldValue();

    @Override
    public JSONObject serialize(RaceLogEvent object) {
        RaceLogFinishPositioningEvent finishPositioningConfirmedEvent = (RaceLogFinishPositioningEvent)object;
        JSONObject result = super.serialize((RaceLogEvent)finishPositioningConfirmedEvent);
        result.put((Object)FIELD_POSITIONED_COMPETITORS, (Object)this.serializePositionedCompetitors(finishPositioningConfirmedEvent.getPositionedCompetitorsIDsNamesMaxPointsReasons()));
        return result;
    }

    private JSONArray serializePositionedCompetitors(CompetitorResults positionedCompetitors) {
        JSONArray jsonPositionedCompetitors = new JSONArray();
        if (positionedCompetitors != null) {
            for (CompetitorResult positionedCompetitor : positionedCompetitors) {
                JSONObject jsonPositionedCompetitor = new JSONObject();
                jsonPositionedCompetitor.put((Object)FIELD_COMPETITOR_ID, (Object)positionedCompetitor.getCompetitorId().toString());
                jsonPositionedCompetitor.put((Object)FIELD_COMPETITOR_NAME, (Object)positionedCompetitor.getName());
                jsonPositionedCompetitor.put((Object)FIELD_COMPETITOR_SHORT_NAME, (Object)positionedCompetitor.getShortName());
                jsonPositionedCompetitor.put((Object)FIELD_COMPETITOR_BOAT_NAME, (Object)positionedCompetitor.getBoatName());
                jsonPositionedCompetitor.put((Object)FIELD_COMPETITOR_BOAT_SAIL_ID, (Object)positionedCompetitor.getBoatSailId());
                jsonPositionedCompetitor.put((Object)FIELD_SCORE_CORRECTIONS_MAX_POINTS_REASON, (Object)positionedCompetitor.getMaxPointsReason().name());
                jsonPositionedCompetitor.put((Object)FIELD_SCORE, (Object)positionedCompetitor.getScore());
                jsonPositionedCompetitor.put((Object)FIELD_COMMENT, (Object)positionedCompetitor.getComment());
                jsonPositionedCompetitor.put((Object)FIELD_MERGE_STATE, (Object)positionedCompetitor.getMergeState().name());
                jsonPositionedCompetitor.put((Object)FIELD_RANK, (Object)positionedCompetitor.getOneBasedRank());
                jsonPositionedCompetitor.put((Object)FIELD_FINISHING_TIME_POINT_AS_MILLIS, positionedCompetitor.getFinishingTime() == null ? null : Long.valueOf(positionedCompetitor.getFinishingTime().asMillis()));
                jsonPositionedCompetitors.add((Object)jsonPositionedCompetitor);
            }
        }
        return jsonPositionedCompetitors;
    }
}

