/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.racelog.impl;

import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.shared.json.JsonSerializer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.function.Function;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ORCCertificateJsonSerializer
implements JsonSerializer<ORCCertificate> {
    public static final String ORC_CERTIFICATE_BEAT_ANGLES = "beatAngles";
    public static final String ORC_CERTIFICATE_RUN_ANGLES = "runAngles";
    public static final String ORC_CERTIFICATE_BEAT_ALLOWANCES = "beatAllowances";
    public static final String ORC_CERTIFICATE_RUN_ALLOWANCES = "runAllowances";
    public static final String ORC_CERTIFICATE_BEAT_VMG_PREDICTIONS = "beatVmgPredictions";
    public static final String ORC_CERTIFICATE_RUN_VMG_PREDICTIONS = "runVmgPredictions";
    public static final String ORC_CERTIFICATE_WINDWARD_LEEWARD_SPEED_PREDICTIONS = "windwardLeewardSpeedPredictions";
    public static final String ORC_CERTIFICATE_LONG_DISTANCE_SPEED_PREDICTIONS = "longDistanceSpeedPredictions";
    public static final String ORC_CERTIFICATE_CIRCULAR_RANDOM_SPEED_PREDICTIONS = "circularRandomSpeedPredictions";
    public static final String ORC_CERTIFICATE_NON_SPINNAKER_SPEED_PREDICTIONS = "nonSpinnakerSpeedPredictions";
    public static final String ORC_CERTIFICATE_TWA_SPEED_PREDICTIONS = "twaSpeedPredictions";
    public static final String ORC_CERTIFICATE_FILE_ID = "fileId";
    public static final String ORC_CERTIFICATE_ISSUING_COUNTRY_IOC = "issuingCountryIOC";
    public static final String ORC_CERTIFICATE_SAILNUMBER = "sailNumber";
    public static final String ORC_CERTIFICATE_BOATNAME = "boatName";
    public static final String ORC_CERTIFICATE_BOATCLASS = "boatClass";
    public static final String ORC_CERTIFICATE_GPH = "gph";
    public static final String ORC_CERTIFICATE_CDL = "cdl";
    public static final String ORC_CERTIFICATE_ID = "ID";
    public static final String ORC_CERTIFICATE_LENGTH = "length";
    public static final String ORC_CERTIFICATE_ISSUE_DATE = "issueDate";
    public static final String ORC_CERTIFICATE_TWS_KNOTS = "ORC_CERTIFICATE_TWS_{0}KT";
    public static final String ORC_CERTIFICATE_TWS_6KT = "ORC_CERTIFICATE_TWS_6KT";
    public static final String ORC_CERTIFICATE_TWS_8KT = "ORC_CERTIFICATE_TWS_8KT";
    public static final String ORC_CERTIFICATE_TWS_10KT = "ORC_CERTIFICATE_TWS_10KT";
    public static final String ORC_CERTIFICATE_TWS_12KT = "ORC_CERTIFICATE_TWS_12KT";
    public static final String ORC_CERTIFICATE_TWS_14KT = "ORC_CERTIFICATE_TWS_14KT";
    public static final String ORC_CERTIFICATE_TWS_16KT = "ORC_CERTIFICATE_TWS_16KT";
    public static final String ORC_CERTIFICATE_TWS_20KT = "ORC_CERTIFICATE_TWS_20KT";
    public static final String ORC_CERTIFICATE_R_PERDICTION = "ORC_CERTIFICATE_R{0}_PREDICTION";
    public static final String ORC_CERTIFICATE_R52_PREDICTION = "ORC_CERTIFICATE_R52_PREDICTION";
    public static final String ORC_CERTIFICATE_R60_PREDICTION = "ORC_CERTIFICATE_R60_PREDICTION";
    public static final String ORC_CERTIFICATE_R75_PREDICTION = "ORC_CERTIFICATE_R75_PREDICTION";
    public static final String ORC_CERTIFICATE_R90_PREDICTION = "ORC_CERTIFICATE_R90_PREDICTION";
    public static final String ORC_CERTIFICATE_R110_PREDICTION = "ORC_CERTIFICATE_R110_PREDICTION";
    public static final String ORC_CERTIFICATE_R120_PREDICTION = "ORC_CERTIFICATE_R120_PREDICTION";
    public static final String ORC_CERTIFICATE_R135_PREDICTION = "ORC_CERTIFICATE_R135_PREDICTION";
    public static final String ORC_CERTIFICATE_R150_PREDICTION = "ORC_CERTIFICATE_R150_PREDICTION";
    public static final String ORC_CERTIFICATE_TRUE_WIND_SPEEDS_IN_KNOTS = "trueWindSpeedsInKnots";
    public static final String ORC_CERTIFICATE_TRUE_WIND_ANGLES_IN_TRUE_DEGREES = "trueWindAnglesInTrueDegrees";
    private static final char DECIMAL_POINT_REPLACEMENT_IN_LITERALS = 'P';

    public JSONObject serialize(ORCCertificate certificate) {
        JSONObject result = new JSONObject();
        result.put((Object)ORC_CERTIFICATE_ID, (Object)certificate.getReferenceNumber());
        result.put((Object)ORC_CERTIFICATE_ISSUING_COUNTRY_IOC, certificate.getIssuingCountry() == null ? null : certificate.getIssuingCountry().getThreeLetterIOCCode());
        result.put((Object)ORC_CERTIFICATE_FILE_ID, (Object)certificate.getFileId());
        result.put((Object)ORC_CERTIFICATE_SAILNUMBER, (Object)certificate.getSailNumber());
        result.put((Object)ORC_CERTIFICATE_BOATNAME, (Object)certificate.getBoatName());
        result.put((Object)ORC_CERTIFICATE_BOATCLASS, (Object)certificate.getBoatClassName());
        result.put((Object)ORC_CERTIFICATE_GPH, (Object)certificate.getGPHInSecondsToTheMile());
        result.put((Object)ORC_CERTIFICATE_CDL, (Object)certificate.getCDL());
        result.put((Object)ORC_CERTIFICATE_LENGTH, certificate.getLengthOverAll() == null ? null : Double.valueOf(certificate.getLengthOverAll().getMeters()));
        result.put((Object)ORC_CERTIFICATE_ISSUE_DATE, certificate.getIssueDate() == null ? null : Long.valueOf(certificate.getIssueDate().asMillis()));
        JSONObject beatAngles = new JSONObject();
        JSONObject runAngles = new JSONObject();
        JSONObject beatAllowances = new JSONObject();
        JSONObject runAllowances = new JSONObject();
        JSONObject beatVMGPredictions = new JSONObject();
        JSONObject runVMGPredictions = new JSONObject();
        JSONObject windwardLeewardPredictions = new JSONObject();
        JSONObject circularRandomPredictions = new JSONObject();
        JSONObject longDistancePredictions = new JSONObject();
        JSONObject nonSpinnakerPredictions = new JSONObject();
        JSONObject velocityPredictionsPerTrueWindSpeedAndAngle = new JSONObject();
        Speed[] speedArray = certificate.getTrueWindSpeeds();
        int n = speedArray.length;
        int n2 = 0;
        while (n2 < n) {
            Speed tws2 = speedArray[n2];
            String keyTWS = ORCCertificateJsonSerializer.speedToKnotsString(tws2);
            JSONObject velocityPredictionsPerTrueWindAngle = new JSONObject();
            beatAngles.put((Object)keyTWS, (Object)((Bearing)certificate.getBeatAngles().get(tws2)).getDegrees());
            runAngles.put((Object)keyTWS, (Object)((Bearing)certificate.getRunAngles().get(tws2)).getDegrees());
            beatAllowances.put((Object)keyTWS, (Object)((Duration)certificate.getBeatAllowances().get(tws2)).asSeconds());
            runAllowances.put((Object)keyTWS, (Object)((Duration)certificate.getRunAllowances().get(tws2)).asSeconds());
            beatVMGPredictions.put((Object)keyTWS, (Object)((Speed)certificate.getBeatVMGPredictions().get(tws2)).getKnots());
            runVMGPredictions.put((Object)keyTWS, (Object)((Speed)certificate.getRunVMGPredictions().get(tws2)).getKnots());
            windwardLeewardPredictions.put((Object)keyTWS, (Object)((Speed)certificate.getWindwardLeewardSpeedPrediction().get(tws2)).getKnots());
            if (certificate.getCircularRandomSpeedPredictions().containsKey(tws2)) {
                circularRandomPredictions.put((Object)keyTWS, (Object)((Speed)certificate.getCircularRandomSpeedPredictions().get(tws2)).getKnots());
            }
            if (certificate.getLongDistanceSpeedPredictions().containsKey(tws2)) {
                longDistancePredictions.put((Object)keyTWS, (Object)((Speed)certificate.getLongDistanceSpeedPredictions().get(tws2)).getKnots());
            }
            if (certificate.getNonSpinnakerSpeedPredictions().containsKey(tws2)) {
                nonSpinnakerPredictions.put((Object)keyTWS, (Object)((Speed)certificate.getNonSpinnakerSpeedPredictions().get(tws2)).getKnots());
            }
            Bearing[] bearingArray = certificate.getTrueWindAngles();
            int n3 = bearingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Bearing twa2 = bearingArray[n4];
                String keyTWA = ORCCertificateJsonSerializer.bearingToDegreeString(twa2);
                velocityPredictionsPerTrueWindAngle.put((Object)keyTWA, (Object)((Speed)((Map)certificate.getVelocityPredictionPerTrueWindSpeedAndAngle().get(tws2)).get(twa2)).getKnots());
                ++n4;
            }
            velocityPredictionsPerTrueWindSpeedAndAngle.put((Object)keyTWS, (Object)velocityPredictionsPerTrueWindAngle);
            ++n2;
        }
        result.put((Object)ORC_CERTIFICATE_BEAT_ANGLES, (Object)beatAngles);
        result.put((Object)ORC_CERTIFICATE_RUN_ANGLES, (Object)runAngles);
        result.put((Object)ORC_CERTIFICATE_BEAT_ALLOWANCES, (Object)beatAllowances);
        result.put((Object)ORC_CERTIFICATE_RUN_ALLOWANCES, (Object)runAllowances);
        result.put((Object)ORC_CERTIFICATE_BEAT_VMG_PREDICTIONS, (Object)beatVMGPredictions);
        result.put((Object)ORC_CERTIFICATE_RUN_VMG_PREDICTIONS, (Object)runVMGPredictions);
        result.put((Object)ORC_CERTIFICATE_WINDWARD_LEEWARD_SPEED_PREDICTIONS, (Object)windwardLeewardPredictions);
        result.put((Object)ORC_CERTIFICATE_LONG_DISTANCE_SPEED_PREDICTIONS, (Object)longDistancePredictions);
        result.put((Object)ORC_CERTIFICATE_CIRCULAR_RANDOM_SPEED_PREDICTIONS, (Object)circularRandomPredictions);
        result.put((Object)ORC_CERTIFICATE_NON_SPINNAKER_SPEED_PREDICTIONS, (Object)nonSpinnakerPredictions);
        result.put((Object)ORC_CERTIFICATE_TWA_SPEED_PREDICTIONS, (Object)velocityPredictionsPerTrueWindSpeedAndAngle);
        if (certificate.getTrueWindAngles() != ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES) {
            result.put((Object)ORC_CERTIFICATE_TRUE_WIND_ANGLES_IN_TRUE_DEGREES, (Object)this.convertObjectsToJsonArrayOfDoubles(twa -> twa.getDegrees(), certificate.getTrueWindAngles()));
        }
        if (certificate.getTrueWindSpeeds() != ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS) {
            result.put((Object)ORC_CERTIFICATE_TRUE_WIND_SPEEDS_IN_KNOTS, (Object)this.convertObjectsToJsonArrayOfDoubles(tws -> tws.getKnots(), certificate.getTrueWindSpeeds()));
        }
        return result;
    }

    @SafeVarargs
    private final <T> JSONArray convertObjectsToJsonArrayOfDoubles(Function<T, Double> converterToDouble, T ... objects) {
        JSONArray jsonArray = new JSONArray();
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            jsonArray.add((Object)converterToDouble.apply(t));
            ++n2;
        }
        return jsonArray;
    }

    public static String speedToKnotsString(Speed speed) {
        String result = null;
        if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[0])) {
            result = ORC_CERTIFICATE_TWS_6KT;
        } else if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[1])) {
            result = ORC_CERTIFICATE_TWS_8KT;
        } else if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[2])) {
            result = ORC_CERTIFICATE_TWS_10KT;
        } else if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[3])) {
            result = ORC_CERTIFICATE_TWS_12KT;
        } else if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[4])) {
            result = ORC_CERTIFICATE_TWS_14KT;
        } else if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[5])) {
            result = ORC_CERTIFICATE_TWS_16KT;
        } else if (speed.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS[6])) {
            result = ORC_CERTIFICATE_TWS_20KT;
        } else {
            String speedKnots = String.valueOf(speed.getKnots());
            speedKnots = speedKnots.replace(".", "P");
            result = MessageFormat.format(ORC_CERTIFICATE_TWS_KNOTS, speedKnots);
        }
        return result;
    }

    public static String bearingToDegreeString(Bearing bearing) {
        String result = null;
        if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[0])) {
            result = ORC_CERTIFICATE_R52_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[1])) {
            result = ORC_CERTIFICATE_R60_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[2])) {
            result = ORC_CERTIFICATE_R75_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[3])) {
            result = ORC_CERTIFICATE_R90_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[4])) {
            result = ORC_CERTIFICATE_R110_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[5])) {
            result = ORC_CERTIFICATE_R120_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[6])) {
            result = ORC_CERTIFICATE_R135_PREDICTION;
        } else if (bearing.equals(ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES[7])) {
            result = ORC_CERTIFICATE_R150_PREDICTION;
        } else {
            String angleDegress = String.valueOf(bearing.getDegrees()).replaceFirst("\\.0+", "").replace('.', 'P');
            result = MessageFormat.format(ORC_CERTIFICATE_R_PERDICTION, angleDegress);
        }
        return result;
    }
}

