/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sse.common.TimePoint;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class BaseRaceLogEventSerializer
implements JsonSerializer<RaceLogEvent> {
    public static final String FIELD_CLASS = "@class";
    public static final String FIELD_ID = "id";
    public static final String FIELD_CREATED_AT = "createdAt";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_PASS_ID = "passId";
    public static final String FIELD_COMPETITORS = "competitors";
    public static final String FIELD_AUTHOR_NAME = "authorName";
    public static final String FIELD_AUTHOR_PRIORITY = "authorPriority";
    protected JsonSerializer<Competitor> competitorSerializer;

    protected abstract String getClassFieldValue();

    public BaseRaceLogEventSerializer(JsonSerializer<Competitor> competitorSerializer) {
        this.competitorSerializer = competitorSerializer;
    }

    public JSONObject serialize(RaceLogEvent object) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_CLASS, (Object)this.getClassFieldValue());
        result.put((Object)FIELD_ID, (Object)object.getId().toString());
        result.put((Object)FIELD_CREATED_AT, (Object)object.getCreatedAt().asMillis());
        TimePoint logicalTimePoint = object.getLogicalTimePoint();
        result.put((Object)FIELD_TIMESTAMP, logicalTimePoint == null ? null : Long.valueOf(logicalTimePoint.asMillis()));
        result.put((Object)FIELD_PASS_ID, (Object)object.getPassId());
        JSONArray competitors = new JSONArray();
        for (Competitor competitor : object.getInvolvedCompetitors()) {
            if (competitor == null) continue;
            competitors.add((Object)this.competitorSerializer.serialize((Object)competitor));
        }
        result.put((Object)FIELD_COMPETITORS, (Object)competitors);
        if (object.getAuthor() != null) {
            result.put((Object)FIELD_AUTHOR_NAME, (Object)object.getAuthor().getName());
            result.put((Object)FIELD_AUTHOR_PRIORITY, (Object)object.getAuthor().getPriority());
        }
        return result;
    }
}

