/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class WindJsonSerializer
implements JsonSerializer<Wind> {
    public static final String FIELD_POSITION = "position";
    public static final String FIELD_TIMEPOINT = "timepoint";
    public static final String FIELD_SPEED_IN_KNOTS = "speedinknots";
    public static final String FIELD_DIRECTION = "direction";
    private final JsonSerializer<Position> positionSerializer;

    public WindJsonSerializer(JsonSerializer<Position> positionSerializer) {
        this.positionSerializer = positionSerializer;
    }

    public JSONObject serialize(Wind wind) {
        JSONObject result = new JSONObject();
        Position position = wind.getPosition();
        if (position != null) {
            result.put((Object)FIELD_POSITION, (Object)this.positionSerializer.serialize((Object)position));
        }
        result.put((Object)FIELD_TIMEPOINT, (Object)wind.getTimePoint().asMillis());
        result.put((Object)FIELD_SPEED_IN_KNOTS, (Object)wind.getKnots());
        result.put((Object)FIELD_DIRECTION, (Object)wind.getBearing().getDegrees());
        return result;
    }
}

