/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicPerson;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.server.gateway.deserialization.impl.NationalityJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.PersonJsonDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.net.URI;
import java.util.HashSet;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TeamJsonDeserializer
implements JsonDeserializer<DynamicTeam> {
    private final JsonDeserializer<DynamicPerson> personDeserializer;
    private static final Logger logger = Logger.getLogger(TeamJsonDeserializer.class.getName());

    public static TeamJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return new TeamJsonDeserializer(new PersonJsonDeserializer(new NationalityJsonDeserializer(baseDomainFactory)));
    }

    public TeamJsonDeserializer(JsonDeserializer<DynamicPerson> personDeserializer) {
        this.personDeserializer = personDeserializer;
    }

    public DynamicTeam deserialize(JSONObject object) throws JsonDeserializationException {
        String name = (String)object.get((Object)"name");
        DynamicPerson coach = (DynamicPerson)this.personDeserializer.deserialize((JSONObject)object.get((Object)"coach"));
        HashSet<DynamicPerson> sailors = new HashSet<DynamicPerson>();
        JSONArray sailorsJson = (JSONArray)object.get((Object)"sailors");
        for (Object sailorObject : sailorsJson) {
            sailors.add((DynamicPerson)this.personDeserializer.deserialize((JSONObject)sailorObject));
        }
        String imageURIAsString = (String)object.get((Object)"imageUri");
        if (imageURIAsString != null) {
            try {
                URI imageURI = URI.create(imageURIAsString);
                return new TeamImpl(name, sailors, coach, imageURI);
            }
            catch (IllegalArgumentException e) {
                logger.warning("Illegal team image URI " + e.getMessage());
            }
        }
        return new TeamImpl(name, sailors, coach);
    }
}

