/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.ui.server.SecurityDTOFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SecurityDTOUtil {
    private SecurityDTOUtil() {
    }

    public static void addSecurityInformation(SecurityService securityService, SecuredDTO securedObject) {
        SecurityDTOUtil.addSecurityInformation((SecurityService)securityService, (SecuredDTO)securedObject, (boolean)false);
    }

    public static void addSecurityInformation(SecurityService securityService, SecuredDTO securedObject, boolean disablePruningForCurrentUser) {
        SecurityDTOUtil.addSecurityInformation((SecurityDTOFactory)new SecurityDTOFactory(), (SecurityService)securityService, (SecuredDTO)securedObject, new HashMap(), new HashMap(), (boolean)disablePruningForCurrentUser);
    }

    public static void addSecurityInformation(SecurityDTOFactory securityDTOFactory, SecurityService securityService, SecuredDTO securedObject, Map<User, StrippedUserDTO> fromOriginalToStrippedDownUser, Map<UserGroup, StrippedUserGroupDTO> fromOriginalToStrippedDownUserGroup) {
        SecurityDTOUtil.addSecurityInformation((SecurityDTOFactory)securityDTOFactory, (SecurityService)securityService, (SecuredDTO)securedObject, fromOriginalToStrippedDownUser, fromOriginalToStrippedDownUserGroup, (boolean)false);
    }

    public static void addSecurityInformation(SecurityDTOFactory securityDTOFactory, SecurityService securityService, SecuredDTO securedObject, Map<User, StrippedUserDTO> fromOriginalToStrippedDownUser, Map<UserGroup, StrippedUserGroupDTO> fromOriginalToStrippedDownUserGroup, boolean disablePruningForCurrentUser) {
        AccessControlListAnnotation accessControlList = securityService.getAccessControlList(securedObject.getIdentifier());
        AccessControlListDTO accessControlListDTO = securityDTOFactory.createAccessControlListDTO(accessControlList == null ? null : (AccessControlList)accessControlList.getAnnotation(), fromOriginalToStrippedDownUser, fromOriginalToStrippedDownUserGroup);
        if (disablePruningForCurrentUser) {
            securedObject.setAccessControlList(accessControlListDTO);
        } else {
            User user = securityService.getCurrentUser();
            Set userGroups = user == null ? Collections.emptySet() : SecurityDTOUtil.getUserGroupsForUser((SecurityService)securityService, (SecurityDTOFactory)securityDTOFactory, (User)user);
            Iterable allUserGroups2 = SecurityDTOUtil.getUserGroupsForUser((SecurityService)securityService, (SecurityDTOFactory)securityDTOFactory, (User)securityService.getAllUser());
            securedObject.setAccessControlList(securityDTOFactory.pruneAccessControlListForUser(accessControlListDTO, userGroups, allUserGroups2));
        }
        OwnershipAnnotation ownership = securityService.getOwnership(securedObject.getIdentifier());
        securedObject.setOwnership(securityDTOFactory.createOwnershipDTO(ownership == null ? null : (Ownership)ownership.getAnnotation(), fromOriginalToStrippedDownUser, fromOriginalToStrippedDownUserGroup));
    }

    private static Iterable<StrippedUserGroupDTO> getUserGroupsForUser(SecurityService securityService, SecurityDTOFactory securityDTOFactory, User user) {
        Iterable<Object> allUserGroups = user != null ? securityDTOFactory.createStrippedUserGroupDTOFromUserGroups(user.getUserGroups(), new HashMap()) : Collections.emptySet();
        return allUserGroups;
    }
}

