/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.view;

import com.google.gwt.debug.client.DebugInfo;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.security.ui.authentication.view.AuthenticationMenuView;
import com.sap.sse.security.ui.client.i18n.StringMessages;

public class AuthenticationMenuViewImpl
implements AuthenticationMenuView {
    private AuthenticationMenuView.Presenter presenter;
    private final Anchor anchor;
    private final String loggedInStyle;
    private final String openStyle;
    private final String premiumStyle;
    private final Label usermenuPremium;

    public AuthenticationMenuViewImpl(Anchor anchor, String loggedInStyle, String openStyle, String premiumStyle) {
        this.anchor = anchor;
        this.loggedInStyle = loggedInStyle;
        this.openStyle = openStyle;
        this.premiumStyle = premiumStyle;
        anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.anchor.ensureDebugId("authenticationMenu");
        this.usermenuPremium = new Label(StringMessages.INSTANCE.premium());
        this.usermenuPremium.setVisible(false);
        this.anchor.getElement().appendChild((Node)this.usermenuPremium.getElement());
    }

    public Widget asWidget() {
        return this.anchor;
    }

    public void setPresenter(AuthenticationMenuView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setAuthenticated(boolean authenticated) {
        this.anchor.setStyleName(this.loggedInStyle, authenticated);
        this.setDebugDataAttribute("data-auth", authenticated);
    }

    public void setOpen(boolean open) {
        this.anchor.setStyleName(this.openStyle, open);
        this.setDebugDataAttribute("data-open", open);
    }

    public void showPremium(boolean premium) {
        this.usermenuPremium.setVisible(premium);
        if (premium) {
            this.anchor.addStyleName(this.premiumStyle);
        } else {
            this.anchor.removeStyleName(this.premiumStyle);
        }
    }

    private void setDebugDataAttribute(String name, boolean value) {
        if (DebugInfo.isDebugIdEnabled()) {
            this.anchor.getElement().setAttribute(name, String.valueOf(value));
        }
    }

    static /* synthetic */ AuthenticationMenuView.Presenter access$0(AuthenticationMenuViewImpl authenticationMenuViewImpl) {
        return authenticationMenuViewImpl.presenter;
    }
}

