/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.util.Arrays;

public interface HasPermissions
extends Named {
    public String getName();

    public Action[] getAvailableActions();

    default public Action getActionByName(String actionName) {
        return (Action)Util.first((Iterable)Util.filter(Arrays.asList(this.getAvailableActions()), action -> action.name().equals(actionName)));
    }

    public boolean supports(Action var1);

    public String getStringPermission(Action ... var1);

    public WildcardPermission getPermission(Action ... var1);

    public String getStringPermissionForTypeRelativeIdentifier(Action var1, TypeRelativeObjectIdentifier var2);

    public String getStringPermissionForObject(Action var1, WithQualifiedObjectIdentifier var2);

    public QualifiedObjectIdentifier getQualifiedObjectIdentifier(TypeRelativeObjectIdentifier var1);

    public WildcardPermission getPermissionForTypeRelativeIdentifier(Action var1, TypeRelativeObjectIdentifier var2);

    public WildcardPermission getPermissionForObject(Action var1, WithQualifiedObjectIdentifier var2);

    public WildcardPermission[] getPermissionsForTypeRelativeIdentifier(Action[] var1, TypeRelativeObjectIdentifier var2);

    public static interface Action {
        public String name();
    }

    public static enum DefaultActions implements Action
    {
        CREATE,
        READ,
        UPDATE,
        DELETE,
        CHANGE_OWNERSHIP,
        CHANGE_ACL;

        public static final Action[] MUTATION_ACTIONS;
        public static final Action[] MUTATION_ACTIONS_FOR_NON_DELETABLE_TYPES;

        static {
            MUTATION_ACTIONS = new Action[]{CREATE, UPDATE, DELETE, CHANGE_OWNERSHIP, CHANGE_ACL};
            MUTATION_ACTIONS_FOR_NON_DELETABLE_TYPES = new Action[]{CREATE, UPDATE, CHANGE_OWNERSHIP, CHANGE_ACL};
        }

        public static Action[] plus(Action ... actions) {
            Action[] result = new Action[DefaultActions.values().length + actions.length];
            System.arraycopy(DefaultActions.values(), 0, result, 0, DefaultActions.values().length);
            System.arraycopy(actions, 0, result, DefaultActions.values().length, actions.length);
            return result;
        }
    }

    public static interface SecuredEnum {
        public Action getPremiumAction();
    }
}

