/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.regattalike.FlexibleLeaderboardAsRegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaAsRegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifierResolver;
import com.sap.sailing.domain.regattalike.RegattaLikeListener;
import com.sap.sailing.server.Replicator;
import com.sap.sailing.server.operationaltransformation.RecordRegattaLogEventOnFlexibleLeaderboard;
import com.sap.sailing.server.operationaltransformation.RecordRegattaLogEventOnRegatta;
import com.sap.sse.replication.OperationWithResult;

public class RegattaLogReplicator
implements RegattaLikeListener {
    private static final long serialVersionUID = 5266000688811193807L;
    private final Replicator service;

    public RegattaLogReplicator(Replicator service) {
        this.service = service;
    }

    public void onRegattaLogEvent(RegattaLikeIdentifier regattaLikeIdentifier, final RegattaLogEvent event) {
        regattaLikeIdentifier.resolve(new RegattaLikeIdentifierResolver(){

            public void resolveOnRegattaIdentifier(RegattaAsRegattaLikeIdentifier regattaLikeParent) {
                RecordRegattaLogEventOnRegatta operation = new RecordRegattaLogEventOnRegatta(regattaLikeParent.getName(), event);
                RegattaLogReplicator.this.service.replicate((OperationWithResult)operation);
            }

            public void resolveOnFlexibleLeaderboardIdentifier(FlexibleLeaderboardAsRegattaLikeIdentifier regattaLikeParent) {
                RecordRegattaLogEventOnFlexibleLeaderboard operation = new RecordRegattaLogEventOnFlexibleLeaderboard(regattaLikeParent.getName(), event);
                RegattaLogReplicator.this.service.replicate((OperationWithResult)operation);
            }
        });
    }
}

