/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inspect fragments of the request URI. You can specify the parts of the URI fragment to inspect and you can narrow the
 * set of URI fragments to inspect by including or excluding specific keys.
 * </p>
 * <p>
 * This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification.
 * </p>
 * <p>
 * Example JSON:
 * <code>"UriFragment": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UriFragment implements SdkPojo, Serializable, ToCopyableBuilder<UriFragment.Builder, UriFragment> {
    private static final SdkField<String> FALLBACK_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallbackBehavior").getter(getter(UriFragment::fallbackBehaviorAsString))
            .setter(setter(Builder::fallbackBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FALLBACK_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fallbackBehavior;

    private UriFragment(BuilderImpl builder) {
        this.fallbackBehavior = builder.fallbackBehavior;
    }

    /**
     * <p>
     * What WAF should do if it fails to completely parse the JSON body. The options are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations and
     * inspection criteria that you defined for the JSON inspection to the body text string.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing failure that
     * it encounters.
     * </p>
     * <p>
     * Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
     * </p>
     * <note>
     * <p>
     * WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When
     * parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
     * >JSON body</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return What WAF should do if it fails to completely parse the JSON body. The options are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations
     *         and inspection criteria that you defined for the JSON inspection to the body text string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing
     *         failure that it encounters.
     *         </p>
     *         <p>
     *         Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
     *         </p>
     *         <note>
     *         <p>
     *         WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON.
     *         When parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a href=
     *         "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
     *         >JSON body</a> in the <i>WAF Developer Guide</i>.
     *         </p>
     * @see FallbackBehavior
     */
    public final FallbackBehavior fallbackBehavior() {
        return FallbackBehavior.fromValue(fallbackBehavior);
    }

    /**
     * <p>
     * What WAF should do if it fails to completely parse the JSON body. The options are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations and
     * inspection criteria that you defined for the JSON inspection to the body text string.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing failure that
     * it encounters.
     * </p>
     * <p>
     * Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
     * </p>
     * <note>
     * <p>
     * WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When
     * parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
     * >JSON body</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return What WAF should do if it fails to completely parse the JSON body. The options are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations
     *         and inspection criteria that you defined for the JSON inspection to the body text string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing
     *         failure that it encounters.
     *         </p>
     *         <p>
     *         Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
     *         </p>
     *         <note>
     *         <p>
     *         WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON.
     *         When parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a href=
     *         "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
     *         >JSON body</a> in the <i>WAF Developer Guide</i>.
     *         </p>
     * @see FallbackBehavior
     */
    public final String fallbackBehaviorAsString() {
        return fallbackBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fallbackBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UriFragment)) {
            return false;
        }
        UriFragment other = (UriFragment) obj;
        return Objects.equals(fallbackBehaviorAsString(), other.fallbackBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UriFragment").add("FallbackBehavior", fallbackBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FallbackBehavior":
            return Optional.ofNullable(clazz.cast(fallbackBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FallbackBehavior", FALLBACK_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UriFragment, T> g) {
        return obj -> g.apply((UriFragment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UriFragment> {
        /**
         * <p>
         * What WAF should do if it fails to completely parse the JSON body. The options are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations and
         * inspection criteria that you defined for the JSON inspection to the body text string.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing failure
         * that it encounters.
         * </p>
         * <p>
         * Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
         * </p>
         * <note>
         * <p>
         * WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When
         * parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a href=
         * "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
         * >JSON body</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param fallbackBehavior
         *        What WAF should do if it fails to completely parse the JSON body. The options are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations
         *        and inspection criteria that you defined for the JSON inspection to the body text string.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing
         *        failure that it encounters.
         *        </p>
         *        <p>
         *        Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
         *        </p>
         *        <note>
         *        <p>
         *        WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid
         *        JSON. When parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
         *        >JSON body</a> in the <i>WAF Developer Guide</i>.
         *        </p>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(String fallbackBehavior);

        /**
         * <p>
         * What WAF should do if it fails to completely parse the JSON body. The options are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations and
         * inspection criteria that you defined for the JSON inspection to the body text string.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing failure
         * that it encounters.
         * </p>
         * <p>
         * Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
         * </p>
         * <note>
         * <p>
         * WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When
         * parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a href=
         * "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
         * >JSON body</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param fallbackBehavior
         *        What WAF should do if it fails to completely parse the JSON body. The options are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations
         *        and inspection criteria that you defined for the JSON inspection to the body text string.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't provide this setting, WAF parses and evaluates the content only up to the first parsing
         *        failure that it encounters.
         *        </p>
         *        <p>
         *        Example JSON: <code>{ "UriFragment": { "FallbackBehavior": "MATCH"} }</code>
         *        </p>
         *        <note>
         *        <p>
         *        WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid
         *        JSON. When parsing succeeds, WAF doesn't apply the fallback behavior. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body"
         *        >JSON body</a> in the <i>WAF Developer Guide</i>.
         *        </p>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(FallbackBehavior fallbackBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String fallbackBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(UriFragment model) {
            fallbackBehavior(model.fallbackBehavior);
        }

        public final String getFallbackBehavior() {
            return fallbackBehavior;
        }

        public final void setFallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
        }

        @Override
        public final Builder fallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
            return this;
        }

        @Override
        public final Builder fallbackBehavior(FallbackBehavior fallbackBehavior) {
            this.fallbackBehavior(fallbackBehavior == null ? null : fallbackBehavior.toString());
            return this;
        }

        @Override
        public UriFragment build() {
            return new UriFragment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
