/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies data protection to apply to the web request data for the web ACL. This is a web ACL level data protection
 * option.
 * </p>
 * <p>
 * The data protection that you configure for the web ACL alters the data that's available for any other data collection
 * activity, including your WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection
 * and management. Your other option for data protection is in the logging configuration, which only affects logging.
 * </p>
 * <p>
 * This is part of the data protection configuration for a web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProtectionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProtectionConfig.Builder, DataProtectionConfig> {
    private static final SdkField<List<DataProtection>> DATA_PROTECTIONS_FIELD = SdkField
            .<List<DataProtection>> builder(MarshallingType.LIST)
            .memberName("DataProtections")
            .getter(getter(DataProtectionConfig::dataProtections))
            .setter(setter(Builder::dataProtections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProtections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataProtection> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataProtection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROTECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DataProtection> dataProtections;

    private DataProtectionConfig(BuilderImpl builder) {
        this.dataProtections = builder.dataProtections;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataProtections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataProtections() {
        return dataProtections != null && !(dataProtections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of data protection configurations for specific web request field types. This is defined for each web
     * ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataProtections} method.
     * </p>
     * 
     * @return An array of data protection configurations for specific web request field types. This is defined for each
     *         web ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
     */
    public final List<DataProtection> dataProtections() {
        return dataProtections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataProtections() ? dataProtections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtectionConfig)) {
            return false;
        }
        DataProtectionConfig other = (DataProtectionConfig) obj;
        return hasDataProtections() == other.hasDataProtections() && Objects.equals(dataProtections(), other.dataProtections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProtectionConfig").add("DataProtections", hasDataProtections() ? dataProtections() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProtections":
            return Optional.ofNullable(clazz.cast(dataProtections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataProtections", DATA_PROTECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProtectionConfig, T> g) {
        return obj -> g.apply((DataProtectionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProtectionConfig> {
        /**
         * <p>
         * An array of data protection configurations for specific web request field types. This is defined for each web
         * ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
         * </p>
         * 
         * @param dataProtections
         *        An array of data protection configurations for specific web request field types. This is defined for
         *        each web ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtections(Collection<DataProtection> dataProtections);

        /**
         * <p>
         * An array of data protection configurations for specific web request field types. This is defined for each web
         * ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
         * </p>
         * 
         * @param dataProtections
         *        An array of data protection configurations for specific web request field types. This is defined for
         *        each web ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtections(DataProtection... dataProtections);

        /**
         * <p>
         * An array of data protection configurations for specific web request field types. This is defined for each web
         * ACL. WAF applies the specified protection to all web requests that the web ACL inspects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.DataProtection.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.DataProtection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.DataProtection.Builder#build()} is called immediately and
         * its result is passed to {@link #dataProtections(List<DataProtection>)}.
         * 
         * @param dataProtections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.DataProtection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProtections(java.util.Collection<DataProtection>)
         */
        Builder dataProtections(Consumer<DataProtection.Builder>... dataProtections);
    }

    static final class BuilderImpl implements Builder {
        private List<DataProtection> dataProtections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtectionConfig model) {
            dataProtections(model.dataProtections);
        }

        public final List<DataProtection.Builder> getDataProtections() {
            List<DataProtection.Builder> result = DataProtectionsCopier.copyToBuilder(this.dataProtections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataProtections(Collection<DataProtection.BuilderImpl> dataProtections) {
            this.dataProtections = DataProtectionsCopier.copyFromBuilder(dataProtections);
        }

        @Override
        public final Builder dataProtections(Collection<DataProtection> dataProtections) {
            this.dataProtections = DataProtectionsCopier.copy(dataProtections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataProtections(DataProtection... dataProtections) {
            dataProtections(Arrays.asList(dataProtections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataProtections(Consumer<DataProtection.Builder>... dataProtections) {
            dataProtections(Stream.of(dataProtections).map(c -> DataProtection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataProtectionConfig build() {
            return new DataProtectionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
