/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadSshPublicKeyRequest extends IamRequest implements
        ToCopyableBuilder<UploadSshPublicKeyRequest.Builder, UploadSshPublicKeyRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UploadSshPublicKeyRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSHPublicKeyBody").getter(getter(UploadSshPublicKeyRequest::sshPublicKeyBody))
            .setter(setter(Builder::sshPublicKeyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKeyBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            SSH_PUBLIC_KEY_BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userName;

    private final String sshPublicKeyBody;

    private UploadSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
    }

    /**
     * <p>
     * The name of the IAM user to associate the SSH public key with.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the IAM user to associate the SSH public key with.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The SSH public key. The public key must be encoded in ssh-rsa format or PEM format. The minimum bit-length of the
     * public key is 2048 bits. For example, you can generate a 2048-bit key, and the resulting PEM file is 1679 bytes
     * long.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * 
     * @return The SSH public key. The public key must be encoded in ssh-rsa format or PEM format. The minimum
     *         bit-length of the public key is 2048 bits. For example, you can generate a 2048-bit key, and the
     *         resulting PEM file is 1679 bytes long.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public final String sshPublicKeyBody() {
        return sshPublicKeyBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSshPublicKeyRequest)) {
            return false;
        }
        UploadSshPublicKeyRequest other = (UploadSshPublicKeyRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(sshPublicKeyBody(), other.sshPublicKeyBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadSshPublicKeyRequest").add("UserName", userName())
                .add("SSHPublicKeyBody", sshPublicKeyBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "SSHPublicKeyBody":
            return Optional.ofNullable(clazz.cast(sshPublicKeyBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("SSHPublicKeyBody", SSH_PUBLIC_KEY_BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadSshPublicKeyRequest, T> g) {
        return obj -> g.apply((UploadSshPublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UploadSshPublicKeyRequest> {
        /**
         * <p>
         * The name of the IAM user to associate the SSH public key with.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param userName
         *        The name of the IAM user to associate the SSH public key with.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The SSH public key. The public key must be encoded in ssh-rsa format or PEM format. The minimum bit-length of
         * the public key is 2048 bits. For example, you can generate a 2048-bit key, and the resulting PEM file is 1679
         * bytes long.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param sshPublicKeyBody
         *        The SSH public key. The public key must be encoded in ssh-rsa format or PEM format. The minimum
         *        bit-length of the public key is 2048 bits. For example, you can generate a 2048-bit key, and the
         *        resulting PEM file is 1679 bytes long.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyBody(String sshPublicKeyBody);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String userName;

        private String sshPublicKeyBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSshPublicKeyRequest model) {
            super(model);
            userName(model.userName);
            sshPublicKeyBody(model.sshPublicKeyBody);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getSshPublicKeyBody() {
            return sshPublicKeyBody;
        }

        public final void setSshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadSshPublicKeyRequest build() {
            return new UploadSshPublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
