/*
    This file is part of RouteConverter.

    RouteConverter is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RouteConverter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RouteConverter; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Copyright (C) 2007 Christian Pesch. All Rights Reserved.
*/

package slash.common.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * An {@link InputStream} which protects the underlying {@link InputStream} from beeing {@link #close()}ed.
 *
 * @author Christian Pesch
 */

public class NotClosingUnderlyingInputStream extends InputStream {
    private InputStream delegate;

    public NotClosingUnderlyingInputStream(InputStream delegate) {
        this.delegate = delegate;
    }


    public int available() throws IOException {
        return delegate.available();
    }

    public synchronized void mark(int readlimit) {
        delegate.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        delegate.reset();
    }

    public boolean markSupported() {
        return delegate.markSupported();
    }

    public int read() throws IOException {
        return delegate.read();
    }

    public void closeUnderlyingInputStream() throws IOException {
        delegate.close();
    }
}
