/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.ListResult;
import com.chargebee.internal.ListRequest;
import com.chargebee.models.ItemPrice;
import com.chargebee.models.enums.ItemType;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeItemPriceListRequest
extends ChargebeeApiRequest {
    private static final BigDecimal CENT_CURRENCY_DIVISOR = new BigDecimal(100);
    private static final Logger logger = Logger.getLogger(ChargebeeItemPriceListRequest.class.getName());
    private final OnResultListener listener;
    private final String offset;
    private Map<String, BigDecimal> itemPrices;
    private String nextOffset;
    private int resultSize;

    public ChargebeeItemPriceListRequest(String offset, OnResultListener listener, SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        super(requestProcessor, chargebeeApiServiceParams);
        this.offset = offset;
        this.listener = listener;
    }

    @Override
    protected ChargebeeInternalApiRequestWrapper createRequest() {
        logger.info(() -> "Fetch Chargebee ItemPrices");
        ItemPrice.ItemPriceListRequest request = (ItemPrice.ItemPriceListRequest)((ItemPrice.ItemPriceListRequest)((ItemPrice.ItemPriceListRequest)ItemPrice.list().limit(100)).itemType().is((Object)ItemType.PLAN)).status().is((Object)ItemPrice.Status.ACTIVE);
        if (this.offset != null && !this.offset.isEmpty()) {
            request.offset(this.offset);
        }
        return new ChargebeeInternalApiRequestWrapper((ListRequest<?>)request);
    }

    @Override
    protected void processResult(ChargebeeInternalApiRequestWrapper request) {
        ListResult result = request.getListResult();
        if (result != null) {
            this.resultSize = result.size();
            this.nextOffset = result.nextOffset();
            this.processListResult(result);
        } else {
            this.onDone(null, null);
        }
    }

    @Override
    protected void handleError(Exception e) {
        logger.log(Level.SEVERE, "Fetching ItemPrice list failed, offset: " + (this.offset == null ? "" : this.offset), e);
        this.onDone(null, null);
    }

    private void processListResult(ListResult result) {
        if (this.itemPrices == null) {
            this.itemPrices = new HashMap<String, BigDecimal>();
        }
        for (ListResult.Entry entry : result) {
            ItemPrice itemPrice = entry.itemPrice();
            BigDecimal priceInDecimal = this.getPriceInDecimal(itemPrice);
            if (priceInDecimal == null) continue;
            this.itemPrices.put(itemPrice.id(), priceInDecimal);
        }
        if (this.itemPrices.size() == this.resultSize) {
            this.onDone(this.itemPrices, this.nextOffset);
        }
    }

    private BigDecimal getPriceInDecimal(ItemPrice itemPrice) {
        if (itemPrice.priceInDecimal() != null) {
            return new BigDecimal(itemPrice.priceInDecimal());
        }
        if (itemPrice.price() != null && "USD".equals(itemPrice.currencyCode()) || "EUR".equals(itemPrice.currencyCode())) {
            BigDecimal bigDecimal = new BigDecimal(itemPrice.price()).divide(CENT_CURRENCY_DIVISOR);
            return bigDecimal;
        }
        logger.log(Level.SEVERE, "Could not parse ItemPrice. Currency not supported: " + itemPrice.currencyCode());
        return null;
    }

    private void onDone(Map<String, BigDecimal> itemPrices, String nextOffset) {
        if (this.listener != null) {
            this.listener.onItemPriceResult(itemPrices, nextOffset);
        }
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onItemPriceResult(Map<String, BigDecimal> var1, String var2);
    }
}

