/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.APIException;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequest;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ChargebeeApiRequest
implements SubscriptionApiRequest {
    private static final Logger logger = Logger.getLogger(ChargebeeApiRequest.class.getName());
    private final SubscriptionApiRequestProcessor requestProcessor;
    private final SubscriptionApiBaseService chargebeeApiServiceParams;

    protected ChargebeeApiRequest(SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        this.requestProcessor = requestProcessor;
        this.chargebeeApiServiceParams = chargebeeApiServiceParams;
    }

    @Override
    public void run() {
        ChargebeeInternalApiRequestWrapper request = this.createRequest();
        if (request != null) {
            try {
                request.request();
                this.processResult(request);
            }
            catch (APIException e) {
                if (e.httpStatusCode == 429) {
                    logger.log(Level.SEVERE, "API rate limit reached, rescheduling request");
                    this.requestProcessor.rescheduleRequestAfterRateLimitExceeded(this);
                } else {
                    this.handleError((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
    }

    protected abstract ChargebeeInternalApiRequestWrapper createRequest();

    @Override
    public SubscriptionApiBaseService getSubscriptionApiBaseService() {
        return this.chargebeeApiServiceParams;
    }

    protected abstract void processResult(ChargebeeInternalApiRequestWrapper var1);

    protected abstract void handleError(Exception var1);

    protected SubscriptionApiRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }
}

