/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs.api;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.security.Action;
import com.sap.sse.security.SecurityUrlPathProvider;
import com.sap.sse.security.jaxrs.AbstractSecurityResource;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.util.HttpRequestUtils;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/restsecurity")
public class SecurityResource
extends AbstractSecurityResource {
    private static final Logger logger = Logger.getLogger(SecurityResource.class.getName());
    public static final String USERS_WITH_PERMISSION_METHOD = "/users_with_permission";
    public static final String HELLO_METHOD = "/hello";
    public static final String CHANGE_PASSWORD_METHOD = "/change_password";
    public static final String FORGOT_PASSWORD_METHOD = "/forgot_password";
    public static final String CREATE_USER_METHOD = "/create_user";
    public static final String USER_METHOD = "/user";
    public static final String HAS_PERMISSION_METHOD = "/has_permission";
    public static final String REMOVE_ACCESS_TOKEN_METHOD = "/remove_access_token";
    public static final String LOGOUT_METHOD = "/logout";
    public static final String RESTSECURITY = "/restsecurity";
    public static final String COMPANY = "company";
    public static final String FULL_NAME = "fullName";
    public static final String EMAIL = "email";
    private static final String SECURITY_UI_URL_PATH = "/security/ui/";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String PERMISSION = "permission";
    public static final String GRANTED = "granted";
    public static final String ACCESS_TOKEN_METHOD = "/access_token";
    public static final String ADD_ROLE_TO_USER_METHOD = "/add_role_to_user";
    public static final String ROLE_DEFINITION_ID = "role_definition_id";
    public static final String QUALIFYING_GROUP_ID = "qualifying_group_id";
    public static final String QUALIFYING_USERNAME = "qualifying_username";
    public static final String TRANSITIVE = "transitive";
    public static final String GET_ROLES_FOR_USER_METHOD = "/get_roles_for_user";
    public static final Object ROLE_NAME = "role_name";
    public static final Object OWNING_GROUP_ID = "owning_group_id";
    public static final Object OWNING_USER_NAME = "owning_user_name";

    @GET
    @Path(value="/hello")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response sayHello() {
        return this.doSayHello();
    }

    @GET
    @Path(value="/users_with_permission")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response getUsersWithPermission(@QueryParam(value="permission") String permission) {
        TimePoint start = TimePoint.now();
        try {
            WildcardPermission wildcardPermission = new WildcardPermission(permission);
            Iterable<User> usersWithPermission = this.getSecurityService().getUsersWithPermissions(wildcardPermission);
            JSONArray usernames = new JSONArray();
            for (User userWithPermission : usersWithPermission) {
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)userWithPermission)) continue;
                usernames.add((Object)userWithPermission.getName());
            }
            logger.fine(() -> "Request for users with permission took " + start.until(TimePoint.now()));
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)this.streamingOutput(usernames)).build();
        }
        catch (Exception e) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    private Response doSayHello() {
        Subject subject = SecurityUtils.getSubject();
        JSONObject result = new JSONObject();
        result.put((Object)"principal", (Object)subject.getPrincipal().toString());
        result.put((Object)"authenticated", (Object)subject.isAuthenticated());
        result.put((Object)"remembered", (Object)subject.isRemembered());
        return Response.ok((Object)this.streamingOutput(result), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Path(value="/hello")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response sayHelloPost() {
        return this.doSayHello();
    }

    @POST
    @Path(value="/change_password")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response changePassword(@FormParam(value="username") String username, @FormParam(value="password") String password) {
        if (!this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username))) {
            return Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
        }
        try {
            this.getSecurityService().updateSimpleUserPassword(username, password);
            return Response.ok().build();
        }
        catch (UserManagementException e) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/forgot_password")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response forgotPassword(@Context UriInfo uriInfo, @QueryParam(value="username") String username, @QueryParam(value="email") String email, @QueryParam(value="application") String application) {
        try {
            User user;
            if (username != null) {
                user = this.getSecurityService().getUserByName(username);
            } else if (email != null) {
                user = this.getSecurityService().getUserByEmail(email);
            } else {
                return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)"username or email must be provided").build();
            }
            if (user == null) {
                return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)"user not found").build();
            }
            this.getSecurityService().resetPassword(user.getName(), this.getPasswordResetURL(uriInfo, application));
            return Response.ok().build();
        }
        catch (MailException | UserManagementException e) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/create_user")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response createUser(final @Context UriInfo uriInfo, final @QueryParam(value="username") String queryUsername, final @FormParam(value="username") String formUsername, final @QueryParam(value="email") String queryEmail, final @FormParam(value="email") String formEmail, final @QueryParam(value="password") String queryPassword, final @FormParam(value="password") String formPassword, final @QueryParam(value="fullName") String queryFullName, final @FormParam(value="fullName") String formFullName, final @QueryParam(value="company") String queryCompany, final @FormParam(value="company") String formCompany, @Context HttpServletRequest request) {
        try {
            final String clientIP = HttpRequestUtils.getClientIP((HttpServletRequest)request);
            User user = this.getSecurityService().checkPermissionForUserCreationAndRevertOnErrorForUserCreation(queryUsername, new Callable<User>(){

                @Override
                public User call() throws Exception {
                    String validationBaseURL = SecurityResource.this.getEmailValidationBaseURL(uriInfo);
                    String usernameToUse = this.preferFirstIfNotNullOrElseSecond(formUsername, queryUsername);
                    String passwordToUse = this.preferFirstIfNotNullOrElseSecond(formPassword, queryPassword);
                    String emailToUse = this.preferFirstIfNotNullOrElseSecond(formEmail, queryEmail);
                    String fullNameToUse = this.preferFirstIfNotNullOrElseSecond(formFullName, queryFullName);
                    String companyToUse = this.preferFirstIfNotNullOrElseSecond(formCompany, queryCompany);
                    User newUser = SecurityResource.this.getSecurityService().createSimpleUser(usernameToUse, emailToUse, passwordToUse, fullNameToUse, companyToUse, Locale.ENGLISH, validationBaseURL, SecurityResource.this.getSecurityService().getDefaultTenantForCurrentUser(), clientIP, true);
                    SecurityUtils.getSubject().login((AuthenticationToken)new UsernamePasswordToken(usernameToUse, passwordToUse));
                    return newUser;
                }

                private String preferFirstIfNotNullOrElseSecond(String first, String second) {
                    String result = first != null ? first : second;
                    return result;
                }
            });
            return this.respondWithAccessTokenForUser(user.getName());
        }
        catch (Exception e) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    private String getEmailValidationBaseURL(UriInfo uriInfo) {
        String urlPath = "/security/ui/EmailValidation.html";
        return this.getContextUrl(uriInfo, "/security/ui/EmailValidation.html");
    }

    private String getPasswordResetURL(UriInfo uriInfo, String application) {
        SecurityUrlPathProvider securityUrlPathProvider = this.getSecurityUrlPathProvider(application);
        String urlPath = securityUrlPathProvider.getPasswordResetUrlPath();
        return this.getContextUrl(uriInfo, urlPath);
    }

    private String getContextUrl(UriInfo uriInfo, String urlPath) {
        String validationBaseURL = String.valueOf(uriInfo.getBaseUri().getScheme()) + "://" + uriInfo.getBaseUri().getHost() + (uriInfo.getBaseUri().getPort() == -1 ? "" : ":" + uriInfo.getBaseUri().getPort()) + urlPath;
        return validationBaseURL;
    }

    @GET
    @Path(value="/user")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getUser(@QueryParam(value="username") String username) {
        Subject subject = SecurityUtils.getSubject();
        User user = this.getSecurityService().getUserByName(username == null ? subject.getPrincipal().toString() : username);
        if (user == null) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)("User " + username + " not known")).build();
        }
        if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user) || this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)user, new HasPermissions.Action[]{SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC})) {
            JSONObject result = new JSONObject();
            result.put((Object)USERNAME, (Object)user.getName());
            if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) {
                result.put((Object)FULL_NAME, (Object)user.getFullName());
                result.put((Object)EMAIL, (Object)user.getEmail());
                result.put((Object)COMPANY, (Object)user.getCompany());
            }
            return Response.ok((Object)this.streamingOutput(result)).build();
        }
        return Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
    }

    @DELETE
    @Path(value="/user")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response deleteUser(@QueryParam(value="username") String username) {
        User user = this.getSecurityService().getUserByName(username);
        if (user != null) {
            return this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)user, () -> {
                try {
                    this.getSecurityService().deleteUser(username);
                    return Response.ok().build();
                }
                catch (UserManagementException e) {
                    return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
                }
            });
        }
        return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)"unknown id").build();
    }

    @PUT
    @Path(value="/add_role_to_user")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response addRoleToUser(@QueryParam(value="username") String username, @QueryParam(value="role_definition_id") String roleDefinitionId, @QueryParam(value="qualifying_group_id") String qualifyingGroupId, @QueryParam(value="qualifying_username") String qualifyingUserName, @QueryParam(value="transitive") Boolean transitive) {
        try {
            Response response;
            final User user = this.getSecurityService().getUserByName(username);
            if (user == null) {
                response = Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"User not found").build();
            } else {
                User qualifiedForUser;
                User user2 = qualifiedForUser = qualifyingUserName == null ? null : this.getSecurityService().getUserByName(qualifyingUserName);
                if (qualifyingUserName != null && qualifiedForUser == null) {
                    response = Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Qualifying user not found").build();
                } else {
                    UserGroup qualifyingGroup;
                    UserGroup userGroup = qualifyingGroup = qualifyingGroupId == null ? null : this.getSecurityService().getUserGroup(UUID.fromString(qualifyingGroupId));
                    if (qualifyingGroupId != null && qualifyingGroup == null) {
                        response = Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Qualifying group not found").build();
                    } else {
                        final Role role = this.getSecurityService().getOrThrowRoleFromIDsAndCheckMetaPermissions(roleDefinitionId == null ? null : UUID.fromString(roleDefinitionId), qualifyingGroup == null ? null : qualifyingGroup.getId(), qualifiedForUser == null ? null : qualifiedForUser.getName(), transitive);
                        final TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
                        final String message = "User " + SecurityUtils.getSubject().getPrincipal() + " added role " + role.getName() + " for user " + username;
                        this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.ROLE_ASSOCIATION, associationTypeIdentifier, associationTypeIdentifier.toString(), new Action(){

                            @Override
                            public void run() throws Exception {
                                QualifiedObjectIdentifier qualifiedObjectAssociationIdentifier = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
                                SecurityResource.this.getSecurityService().addToAccessControlList(qualifiedObjectAssociationIdentifier, null, HasPermissions.DefaultActions.READ.name());
                                SecurityResource.this.getSecurityService().addRoleForUser(user, role);
                                logger.info(message);
                            }
                        });
                        response = Response.ok().build();
                    }
                }
            }
            return response;
        }
        catch (UserManagementException e) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/get_roles_for_user")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getRoles(@QueryParam(value="username") String username) {
        User user;
        JSONArray result = new JSONArray();
        User user2 = user = username == null ? this.getSecurityService().getCurrentUser() : this.getSecurityService().getUserByName(username);
        if (user != null) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)user);
            for (Role role : user.getRoles()) {
                JSONObject roleJson = new JSONObject();
                result.add((Object)roleJson);
                TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
                QualifiedObjectIdentifier qualifiedObjectIdentifierForRoleAssociation = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
                if (!this.getSecurityService().hasCurrentUserAnyPermission(qualifiedObjectIdentifierForRoleAssociation.getPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
                OwnershipAnnotation ownership = this.getSecurityService().getOwnership(qualifiedObjectIdentifierForRoleAssociation);
                roleJson.put((Object)ROLE_DEFINITION_ID, (Object)role.getRoleDefinition().getIdAsString());
                roleJson.put(ROLE_NAME, (Object)role.getRoleDefinition().getName());
                roleJson.put(OWNING_GROUP_ID, ownership == null ? null : (ownership.getAnnotation() == null ? null : (((Ownership)ownership.getAnnotation()).getTenantOwner() == null ? null : ((UserGroup)((Ownership)ownership.getAnnotation()).getTenantOwner()).getId().toString())));
                roleJson.put(OWNING_USER_NAME, ownership == null ? null : (ownership.getAnnotation() == null ? null : (((Ownership)ownership.getAnnotation()).getUserOwner() == null ? null : ((User)((Ownership)ownership.getAnnotation()).getUserOwner()).getName())));
                roleJson.put((Object)QUALIFYING_GROUP_ID, role.getQualifiedForTenant() == null ? null : ((UserGroup)role.getQualifiedForTenant()).getId().toString());
                roleJson.put((Object)QUALIFYING_USERNAME, role.getQualifiedForUser() == null ? null : ((User)role.getQualifiedForUser()).getName());
                roleJson.put((Object)TRANSITIVE, (Object)role.isTransitive());
            }
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @PUT
    @Path(value="/user")
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response updateUser(@Context UriInfo uriInfo, @QueryParam(value="username") String username, @QueryParam(value="email") String email, @QueryParam(value="fullName") String fullName, @QueryParam(value="company") String company) {
        if (!this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username))) {
            return Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
        }
        try {
            User user = this.getSecurityService().getUserByName(username);
            if (user == null) {
                return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)("User " + username + " not known")).build();
            }
            this.getSecurityService().updateUserProperties(username, fullName, company, user.getLocale());
            if (!Util.equalsWithNull((Object)user.getEmail(), (Object)email)) {
                this.getSecurityService().updateSimpleUserEmail(username, email, this.getEmailValidationBaseURL(uriInfo));
            }
            return Response.ok().build();
        }
        catch (UserManagementException e) {
            return Response.status((Response.StatusType)ClientResponse.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/access_token")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response accessToken() {
        return this.respondWithAccessTokenForAuthenticatedSubject();
    }

    @POST
    @Path(value="/access_token")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response accessTokenPost() {
        return this.respondWithAccessTokenForAuthenticatedSubject();
    }

    @GET
    @Path(value="/logout")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response logout() {
        return this.logoutPost();
    }

    @POST
    @Path(value="/logout")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response logoutPost() {
        this.getSecurityService().logout();
        return Response.ok().build();
    }

    @GET
    @Path(value="/remove_access_token")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response removeAccessToken() {
        return this.removeAccessTokenPost();
    }

    @POST
    @Path(value="/remove_access_token")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response removeAccessTokenPost() {
        Response result;
        Object principal = SecurityUtils.getSubject().getPrincipal();
        if (principal != null) {
            String username = principal.toString();
            result = this.respondToRemoveAccessTokenForUser(username);
        } else {
            result = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
        }
        return result;
    }

    public Response respondToRemoveAccessTokenForUser(String username) {
        this.getSecurityService().removeAccessToken(username);
        Response result = this.respondWithAccessTokenForAuthenticatedSubject();
        return result;
    }

    @GET
    @Path(value="/has_permission")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getPermission(@QueryParam(value="permission") List<String> permissionsAsStrings) {
        JSONArray result = new JSONArray();
        for (String permissionAsString : permissionsAsStrings) {
            JSONObject entry = new JSONObject();
            result.add((Object)entry);
            entry.put((Object)PERMISSION, (Object)permissionAsString);
            entry.put((Object)GRANTED, (Object)SecurityUtils.getSubject().isPermitted(permissionAsString));
        }
        return Response.ok((Object)this.streamingOutput(result), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private Response respondWithAccessTokenForAuthenticatedSubject() {
        Response result;
        Object principal = SecurityUtils.getSubject().getPrincipal();
        if (principal != null) {
            String username = principal.toString();
            result = this.respondWithAccessTokenForUser(username);
        } else {
            result = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).build();
        }
        return result;
    }

    Response respondWithAccessTokenForUser(String username) {
        String accessToken;
        JSONObject response = new JSONObject();
        response.put((Object)USERNAME, (Object)username);
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username))) {
            accessToken = this.getSecurityService().getOrCreateAccessToken(username);
        } else {
            accessToken = this.getSecurityService().getAccessToken(username);
            if (accessToken == null) {
                throw new AuthorizationException("No access token was found and the permission to create one is lacking.");
            }
        }
        response.put((Object)ACCESS_TOKEN, (Object)accessToken);
        return Response.ok((Object)this.streamingOutput(response), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }
}

