/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;

@Provider
public class ShiroAuthorizationExceptionTo401ResponseMapper
implements ExceptionMapper<AuthorizationException> {
    private static final Logger logger = Logger.getLogger(ShiroAuthorizationExceptionTo401ResponseMapper.class.getName());

    public Response toResponse(AuthorizationException exception) {
        Subject subject = SecurityUtils.getSubject();
        String principalAsString = subject != null && subject.getPrincipal() != null ? subject.getPrincipal().toString() : null;
        logger.log(Level.WARNING, "AuthorizationException occurred in REST call" + (principalAsString == null ? "" : " for user " + principalAsString + ": " + exception.getMessage()));
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exception.getMessage()).build();
    }
}

