/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.jaxrs;

import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.osgi.CachedOsgiTypeBasedServiceFinderFactory;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SecurityUrlPathProvider;
import com.sap.sse.security.impl.SecurityUrlPathProviderDefaultImpl;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class RestServletContainer
extends ServletContainer {
    private static final long serialVersionUID = 3129261471808425410L;
    private static final String OSGI_RFC66_WEBBUNDLE_BUNDLECONTEXT_NAME = "osgi-bundlecontext";
    public static final String SECURITY_SERVICE_TRACKER_NAME = "securityServiceTracker";
    public static final String SECURITY_URL_PATH_PROVIDER_NAME = "securityUrlPathProvider";
    private ServiceTracker<SecurityService, SecurityService> securityServiceTracker;
    private CachedOsgiTypeBasedServiceFinderFactory securityUrlPathFinderFactory;

    public RestServletContainer() {
    }

    public RestServletContainer(Application app) {
        super(app);
    }

    public RestServletContainer(Class<? extends Application> appClass) {
        super(appClass);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        BundleContext context = this.getBundleContext(config);
        this.securityServiceTracker = new ServiceTracker(context, SecurityService.class.getName(), null);
        this.securityServiceTracker.open();
        config.getServletContext().setAttribute(SECURITY_SERVICE_TRACKER_NAME, this.securityServiceTracker);
        this.securityUrlPathFinderFactory = new CachedOsgiTypeBasedServiceFinderFactory(context);
        TypeBasedServiceFinder securityUrlPathFinder = this.securityUrlPathFinderFactory.createServiceFinder(SecurityUrlPathProvider.class);
        securityUrlPathFinder.setFallbackService((Object)new SecurityUrlPathProviderDefaultImpl());
        config.getServletContext().setAttribute(SECURITY_URL_PATH_PROVIDER_NAME, (Object)securityUrlPathFinder);
    }

    protected BundleContext getBundleContext(ServletConfig config) {
        return (BundleContext)config.getServletContext().getAttribute(OSGI_RFC66_WEBBUNDLE_BUNDLECONTEXT_NAME);
    }

    public void destroy() {
        super.destroy();
        if (this.securityServiceTracker != null) {
            this.securityServiceTracker.close();
        }
        if (this.securityUrlPathFinderFactory != null) {
            this.securityUrlPathFinderFactory.close();
        }
    }

    public SecurityService getService() {
        return (SecurityService)this.securityServiceTracker.getService();
    }
}

