/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.security.PermissionChangeListener;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PermissionChangeListeners {
    private final NamedReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>>> permissionChangeListenersByType;
    private final ConcurrentHashMap<QualifiedObjectIdentifier, ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>>> permissionChangeListenersByObject;
    private final SecurityService securityService;

    PermissionChangeListeners(SecurityService securityService) {
        this.securityService = securityService;
        this.lock = new NamedReentrantReadWriteLock(PermissionChangeListeners.class.getSimpleName(), false);
        this.permissionChangeListenersByType = new ConcurrentHashMap();
        this.permissionChangeListenersByObject = new ConcurrentHashMap();
    }

    void addPermissionChangeListener(WildcardPermission permission, PermissionChangeListener listener) {
        this.addOrRemovePermissionChangeListener(permission, listener, this::addPermissionChangeListenerInternal);
    }

    void removePermissionChangeListener(WildcardPermission permission, PermissionChangeListener listener) {
        this.addOrRemovePermissionChangeListener(permission, listener, this::removePermissionChangeListenerInternal);
    }

    private void addOrRemovePermissionChangeListener(WildcardPermission permission, PermissionChangeListener listener, ListenerAdderOrRemover adderOrRemover) {
        if (permission.getParts().size() < 3 || ((Set)permission.getParts().get(0)).contains("*") || ((Set)permission.getParts().get(2)).contains("*")) {
            throw new IllegalArgumentException("PermissionChangeListener can not be registered for wildcard permission " + permission + ". Use at least specific type(s) and object ID(s).");
        }
        for (QualifiedObjectIdentifier oid : permission.getQualifiedObjectIdentifiers()) {
            for (String action : this.getActions(oid.getTypeIdentifier(), (Set)permission.getParts().get(1))) {
                adderOrRemover.addOrRemove(oid, action, listener);
            }
        }
    }

    private void addPermissionChangeListenerInternal(QualifiedObjectIdentifier oid, String actionName, PermissionChangeListener listener) {
        WildcardPermission singlePermission = oid.getPermission(actionName);
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lock, () -> {
            this.permissionChangeListenersByType.computeIfAbsent(oid.getTypeIdentifier(), typeName -> new ConcurrentHashMap()).computeIfAbsent(singlePermission, permission -> new ConcurrentHashMap()).put(listener, true);
            this.permissionChangeListenersByObject.computeIfAbsent(oid, p -> new ConcurrentHashMap()).computeIfAbsent(singlePermission, permission -> new ConcurrentHashMap()).put(listener, true);
        });
    }

    private void removePermissionChangeListenerInternal(QualifiedObjectIdentifier oid, String actionName, PermissionChangeListener listener) {
        WildcardPermission singlePermission = oid.getPermission(actionName);
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.lock, () -> {
            ConcurrentHashMap<PermissionChangeListener, Boolean> innerMap2;
            ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> map2;
            ConcurrentHashMap<PermissionChangeListener, Boolean> innerMap;
            ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> map = this.permissionChangeListenersByType.get(oid.getTypeIdentifier());
            if (map != null && (innerMap = map.get(singlePermission)) != null) {
                innerMap.remove(listener);
            }
            if ((map2 = this.permissionChangeListenersByObject.get(oid)) != null && (innerMap2 = map2.get(singlePermission)) != null) {
                innerMap2.remove(listener);
            }
        });
    }

    private Iterable<String> getActions(String securedTypeName, Set<String> actions) {
        HashSet<String> result = new HashSet<String>();
        HasPermissions securedType = this.securityService.getHasPermissionsByName(securedTypeName);
        if (securedType != null) {
            for (String actionString : actions) {
                if (actionString.equals("*")) {
                    HasPermissions.Action[] actionArray = securedType.getAvailableActions();
                    int n = actionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HasPermissions.Action action = actionArray[n2];
                        result.add(action.name());
                        ++n2;
                    }
                    continue;
                }
                result.add(actionString);
            }
        }
        return result;
    }

    void roleAddedToOrRemovedFromUser(User user, Role role) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            block0: for (WildcardPermission permission : role.getPermissions()) {
                Iterable<String> typesToScan = this.getTypesToScan(permission);
                for (String typeName : typesToScan) {
                    ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> permissionChangeListenersForType = this.permissionChangeListenersByType.get(typeName);
                    if (permissionChangeListenersForType == null) continue;
                    for (Map.Entry<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> permissionAndListener : permissionChangeListenersForType.entrySet()) {
                        QualifiedObjectIdentifier objectId = (QualifiedObjectIdentifier)permissionAndListener.getKey().getQualifiedObjectIdentifiers().iterator().next();
                        OwnershipAnnotation ownershipAnnotation = this.securityService.getOwnership(objectId);
                        if (ownershipAnnotation != null && !this.matchesQualification((Ownership)ownershipAnnotation.getAnnotation(), (UserGroup)role.getQualifiedForTenant(), (User)role.getQualifiedForUser()) || !permission.implies(permissionAndListener.getKey())) continue;
                        this.notifyListeners(permissionAndListener.getKey(), permissionAndListener.getValue().keySet());
                        break block0;
                    }
                }
            }
        });
    }

    private Iterable<String> getTypesToScan(WildcardPermission permission) {
        Iterable typesToScan = permission.getParts().isEmpty() ? Collections.emptySet() : (((Set)permission.getParts().get(0)).contains("*") ? this.permissionChangeListenersByType.keySet() : Util.filter((Iterable)((Iterable)permission.getParts().get(0)), typeName -> this.permissionChangeListenersByType.containsKey(typeName)));
        return typesToScan;
    }

    private void notifyListeners(WildcardPermission permission, Iterable<PermissionChangeListener> listeners) {
        Iterable<User> usersWithPermissions = this.securityService.getUsersWithPermissions(permission);
        for (PermissionChangeListener listener : listeners) {
            listener.setOfUsersWithPermissionChanged(permission, usersWithPermissions);
        }
    }

    private boolean matchesQualification(Ownership ownership, UserGroup qualifiedForTenant, User qualifiedForUser) {
        return !(qualifiedForTenant != null && !Util.equalsWithNull((Object)qualifiedForTenant, (Object)ownership.getTenantOwner()) || qualifiedForUser != null && !Util.equalsWithNull((Object)qualifiedForUser, (Object)ownership.getUserOwner()));
    }

    void permissionAddedToOrRemovedFromUser(User user, WildcardPermission permission) {
        this.notifyListenersForPermissionsImplied(permission);
    }

    private void notifyListenersForPermissionsImplied(WildcardPermission permission) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            block0: for (String typeName : this.getTypesToScan(permission)) {
                ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> permissionChangeListenersForType = this.permissionChangeListenersByType.get(typeName);
                if (permissionChangeListenersForType == null) continue;
                for (Map.Entry<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> permissionAndListener : permissionChangeListenersForType.entrySet()) {
                    if (!permission.implies(permissionAndListener.getKey())) continue;
                    this.notifyListeners(permissionAndListener.getKey(), permissionAndListener.getValue().keySet());
                    break block0;
                }
            }
        });
    }

    void userAddedToOrRemovedFromGroup(User user, UserGroup group) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            for (Map.Entry<QualifiedObjectIdentifier, ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>>> objectIdAndListeners : this.permissionChangeListenersByObject.entrySet()) {
                OwnershipAnnotation ownershipAnnotation = this.securityService.getOwnership(objectIdAndListeners.getKey());
                if (ownershipAnnotation == null || !Util.equalsWithNull((Object)((Ownership)ownershipAnnotation.getAnnotation()).getTenantOwner(), (Object)group)) continue;
                Util.filter(objectIdAndListeners.getValue().entrySet(), permissionAndListeners -> this.isImpliedByGroupRoleForMembersOrAll((WildcardPermission)permissionAndListeners.getKey(), group)).forEach(pAndL -> this.notifyListeners((WildcardPermission)pAndL.getKey(), ((ConcurrentHashMap)pAndL.getValue()).keySet()));
            }
        });
    }

    private boolean isImpliedByGroupRoleForMembersOrAll(WildcardPermission permission, UserGroup group) {
        return !Util.isEmpty((Iterable)Util.filter(group.getRoleDefinitionMap().entrySet(), roleAndForAll -> (Boolean)roleAndForAll.getValue() == false && !Util.isEmpty((Iterable)Util.filter((Iterable)((RoleDefinition)roleAndForAll.getKey()).getPermissions(), p -> p.implies(permission)))));
    }

    void aclChanged(QualifiedObjectIdentifier objectId) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> permissionChangeListenersForObject = this.permissionChangeListenersByObject.get(objectId);
            if (permissionChangeListenersForObject != null) {
                for (Map.Entry<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> listenersForObject : permissionChangeListenersForObject.entrySet()) {
                    this.notifyListeners(listenersForObject.getKey(), listenersForObject.getValue().keySet());
                }
            }
        });
    }

    void permissionAddedToOrRemovedFromRoleDefinition(RoleDefinition roleDefinition, Iterable<WildcardPermission> oldPermissions, Iterable<WildcardPermission> newPermissions) {
        Iterable permissionsAdded = Util.filter(newPermissions, newPermission -> !Util.contains((Iterable)oldPermissions, (Object)newPermission));
        Iterable permissionsRemoved = Util.filter(oldPermissions, oldPermission -> !Util.contains((Iterable)newPermissions, (Object)oldPermission));
        for (WildcardPermission permissionAdded : permissionsAdded) {
            this.notifyListenersForPermissionsImplied(permissionAdded);
        }
        for (WildcardPermission permissionRemoved : permissionsRemoved) {
            this.notifyListenersForPermissionsImplied(permissionRemoved);
        }
    }

    void roleAddedToOrRemovedFromGroup(UserGroup group, RoleDefinition roleDefinition) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            for (Map.Entry<QualifiedObjectIdentifier, ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>>> listenersForObject : this.permissionChangeListenersByObject.entrySet()) {
                OwnershipAnnotation ownershipAnnotation = this.securityService.getOwnership(listenersForObject.getKey());
                if (ownershipAnnotation == null || !Util.equalsWithNull((Object)((Ownership)ownershipAnnotation.getAnnotation()).getTenantOwner(), (Object)group)) continue;
                for (Map.Entry<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> e : listenersForObject.getValue().entrySet()) {
                    if (Util.isEmpty((Iterable)Util.filter((Iterable)roleDefinition.getPermissions(), p -> p.implies((WildcardPermission)e.getKey())))) continue;
                    this.notifyListeners(e.getKey(), e.getValue().keySet());
                }
            }
        });
    }

    void roleDefinitionRemoved(RoleDefinition roleDefinition) {
        for (WildcardPermission permission : roleDefinition.getPermissions()) {
            this.notifyListenersForPermissionsImplied(permission);
        }
    }

    void ownershipChanged(QualifiedObjectIdentifier objectId) {
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> listenersForObject = this.permissionChangeListenersByObject.get(objectId);
            if (listenersForObject != null) {
                for (Map.Entry<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> e : listenersForObject.entrySet()) {
                    this.notifyListeners(e.getKey(), e.getValue().keySet());
                }
            }
        });
    }

    void userDeleted(User user) {
        HashMap<WildcardPermission, Set> listenersToNotify = new HashMap<WildcardPermission, Set>();
        LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.lock, () -> {
            User allUser = this.securityService.getAllUser();
            for (Map.Entry<QualifiedObjectIdentifier, ConcurrentHashMap<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>>> permissionsAndListeners : this.permissionChangeListenersByObject.entrySet()) {
                OwnershipAnnotation ownershipAnnotation = this.securityService.getOwnership(permissionsAndListeners.getKey());
                AccessControlListAnnotation aclAnnotation = this.securityService.getAccessControlList(permissionsAndListeners.getKey());
                for (Map.Entry<WildcardPermission, ConcurrentHashMap<PermissionChangeListener, Boolean>> permissionAndListeners : permissionsAndListeners.getValue().entrySet()) {
                    if (!PermissionChecker.isPermitted((WildcardPermission)permissionAndListeners.getKey(), (SecurityUser)user, (SecurityUser)allUser, (AbstractOwnership)(ownershipAnnotation == null ? null : (Ownership)ownershipAnnotation.getAnnotation()), aclAnnotation == null ? null : (AccessControlList)aclAnnotation.getAnnotation())) continue;
                    ((ConcurrentHashMap.KeySetView)permissionAndListeners.getValue().keySet()).forEach(listener -> {
                        boolean bl = Util.addToValueSet((Map)listenersToNotify, (Object)((WildcardPermission)permissionAndListeners.getKey()), (Object)listener);
                    });
                }
            }
        });
        listenersToNotify.forEach((permission, listeners) -> this.notifyListeners((WildcardPermission)permission, (Iterable<PermissionChangeListener>)listeners));
    }

    @FunctionalInterface
    private static interface ListenerAdderOrRemover {
        public void addOrRemove(QualifiedObjectIdentifier var1, String var2, PermissionChangeListener var3);
    }
}

