/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.interfaces.UserStore;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class StoreServiceTrackerCustomizer<T>
implements ServiceTrackerCustomizer<T, T> {
    private final Logger logger;
    private final BundleContext context;

    public StoreServiceTrackerCustomizer(BundleContext context, Logger logger) {
        this.logger = logger;
        this.context = context;
    }

    protected abstract void setStore(T var1);

    protected abstract void removeStore();

    protected abstract T getStore();

    public T addingService(ServiceReference<T> reference) {
        Object contextStore = this.context.getService(reference);
        T thisStore = this.getStore();
        if (thisStore != null && thisStore != contextStore) {
            this.logger.severe("Multiple " + UserStore.class.getSimpleName() + " instances found. Only one instance is handled.");
        } else {
            this.setStore(contextStore);
        }
        return (T)contextStore;
    }

    public void modifiedService(ServiceReference<T> reference, T store) {
    }

    public void removedService(ServiceReference<T> reference, T store) {
        if (this.getStore() == store) {
            this.removeStore();
        }
    }
}

