/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.BearerAuthenticationToken;
import com.sap.sse.security.impl.FormAuthenticationFilterWithPublicCreateToken;
import com.sap.sse.util.HttpRequestUtils;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;

public class BearerTokenOrBasicOrFormAuthenticationFilter
extends BasicHttpAuthenticationFilter {
    private static final String BEARER = "Bearer";
    private final FormAuthenticationFilterWithPublicCreateToken formAuthenticationFilter = new FormAuthenticationFilterWithPublicCreateToken();

    public BearerTokenOrBasicOrFormAuthenticationFilter() {
        this("SAP");
    }

    protected BearerTokenOrBasicOrFormAuthenticationFilter(String applicationName) {
        this.setApplicationName(applicationName);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String authorizationHeader = this.getAuthzHeader(request);
        if (authorizationHeader != null && !authorizationHeader.isEmpty()) {
            String[] authTokens = authorizationHeader.split(" ");
            if (authTokens[0].equalsIgnoreCase(BEARER)) {
                return authTokens.length < 2 ? null : new BearerAuthenticationToken(authTokens[1], request instanceof HttpServletRequest ? HttpRequestUtils.getClientIP((HttpServletRequest)((HttpServletRequest)request)) : null, request instanceof HttpServletRequest ? HttpRequestUtils.getUserAgent((HttpServletRequest)((HttpServletRequest)request)) : null);
            }
            if (authTokens[0].equalsIgnoreCase("BASIC")) {
                return super.createToken(request, response);
            }
        }
        return this.formAuthenticationFilter.createToken(request, response);
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        String authzScheme = BEARER.toLowerCase(Locale.ENGLISH);
        String authzHeader = this.getAuthzHeader(request);
        return authzHeader != null && authzHeader.toLowerCase(Locale.ENGLISH).startsWith(authzScheme) || super.isLoginAttempt(request, response) || this.formAuthenticationFilter.isLoginSubmission(request, response);
    }
}

