/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakReferenceWithCleanerCallback<T>
extends WeakReference<T> {
    private static final Logger logger = Logger.getLogger(WeakReferenceWithCleanerCallback.class.getName());
    private static ReferenceQueue<WeakReferenceWithCleanerCallback<?>> queue = new ReferenceQueue();
    private final Runnable cleanerCallback;

    static {
        Thread t = new Thread(String.valueOf(WeakReferenceWithCleanerCallback.class.getSimpleName()) + " weak reference cleaner"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Reference ref;
                            Runnable callback;
                            if ((callback = ((WeakReferenceWithCleanerCallback)(ref = queue.remove())).cleanerCallback) == null) {
                                continue;
                            }
                            callback.run();
                        }
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.SEVERE, "Error trying to clean weak reference", e);
                        continue;
                    }
                    catch (Exception e2) {
                        logger.severe("Shouldn't have gotten here. Continuing...");
                        continue;
                    }
                    break;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public WeakReferenceWithCleanerCallback(T referent, Runnable cleanerCallback) {
        super(referent);
        this.cleanerCallback = cleanerCallback;
    }
}

